/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tianfu.json.internal.bind;

import com.tongtech.tianfu.json.Json;
import com.tongtech.tianfu.json.TypeAdapter;
import com.tongtech.tianfu.json.TypeAdapterFactory;
import com.tongtech.tianfu.json.internal.$Json$Types;
import com.tongtech.tianfu.json.internal.ConstructorConstructor;
import com.tongtech.tianfu.json.internal.ObjectConstructor;
import com.tongtech.tianfu.json.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.tongtech.tianfu.json.reflect.TypeToken;
import com.tongtech.tianfu.json.stream.JsonReader;
import com.tongtech.tianfu.json.stream.JsonToken;
import com.tongtech.tianfu.json.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Json json, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = $Json$Types.getCollectionElementType(type, rawType);
        TypeAdapter<?> elementTypeAdapter = json.getAdapter(TypeToken.get(elementType));
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken);
        Adapter result = new Adapter(json, elementType, elementTypeAdapter, constructor);
        return result;
    }

    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        public Adapter(Json context, Type elementType, TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.elementTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, elementTypeAdapter, elementType);
            this.constructor = constructor;
        }

        @Override
        public Collection<E> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Collection<E> collection = this.constructor.construct();
            in.beginArray();
            while (in.hasNext()) {
                E instance = this.elementTypeAdapter.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }

        @Override
        public void write(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : collection) {
                this.elementTypeAdapter.write(out, element);
            }
            out.endArray();
        }
    }
}

