package com.testor.ddd.safetyControl.application.service.equipmentManage;

import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.EquipmentStatisticsVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface EquipmentManageService {
    /**
     * 编辑设备
     * @param equipmentDto
     * @return
     */
    BaseResponse editEquipment(TSafeEquipmentDTO equipmentDto);

    BaseResponseList<TSafeEquipmentVO> listByPage(TSafeEquipmentDTOParam param);

    TSafeEquipmentDTO findById(String id);

    TSafeEquipmentVO findDetailById(String id);

    BaseResponse deleteById(String id);

    /**
     * 设备台账—若设备“安装位置-作业区域”字段所选空间为此区域，则自动删除此设备；
     * @param SpaceId
     * @return
     */
    boolean deleteBySpaceId(Integer type, String SpaceId);

    /**
     * 根据条件统计设备信息
     * @param orgId
     * @return
     */
    EquipmentStatisticsVO statisticsEquipment(String orgId);

    public Integer replaceCode(String spaceTypeId, String oldCode, String newCode);

    /**
     * 通过设备系统类型、设备类型删除
     * @param type 0-设备系统类型； 1-设备类型
     * @param typeId
     * @return
     */
    boolean deleteByEquipmentType(int type, String typeId);

    /**
     * 导入设备
     * @param file
     * @return
     * @throws IOException
     */
    BaseResponse<String> importEquipment(MultipartFile file) throws IOException;

    /**
     * 设备列表 （安全风险 拉下数据）
     * @param param
     * @return
     */
    List<TSafeEquipmentVO> listForRisk(TSafeEquipmentDTOParam param);
}

