package com.testor.ddd.safetyControl.domain.riskSource.entity;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeRiskSourceRepo {

    TSafeRiskSourceDTO insert(TSafeRiskSourceDTO riskSourceDTO);

    TSafeRiskSourceDTO updateById(TSafeRiskSourceDTO riskSourceDTO);

    /**
     * 分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeRiskSourceVO> listPage(TSafeRiskSourceDTOParam param);

    TSafeRiskSourceDTO findById(String id);

    boolean deleteById(String id);

    List<TSafeRiskSourceDTO> listAllEntity(TSafeRiskSourceDTOParam param);

//    boolean saveBatch(List<TSafeRiskSourceDTO> riskSourceDTOList);

    /**
     * 根据id查看详情
     * @param id
     * @return
     */
    TSafeRiskSourceVO findDetailById(String id);

    /**
     * 列表不分页
     * @param param
     * @return
     */
    List<TSafeRiskSourceDTO> listAll(TSafeRiskSourceDTOParam param);

    /**
     *
     * @param type 1-设备; 2-空间(作业区域)；  3-空间(车间场所)；
     * @param bizId type=1-设备id; 2-空间(作业区域)id；  3-空间(车间场所)id；
     * @return
     */
    boolean deleteBySpaceOrEquipment(Integer type, String bizId);

    /**
     * 检测 名称、编码 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeRiskSourceDTO> checkUniqueness(String orgId, String sourceId, String name);

    /**
     * 危险源导出数据列表
     * @param param
     * @return
     */
    List<TSafeRiskSourceVO> listExpData(TSafeRiskSourceDTOParam param);

}
