package com.testor.ddd.safetyControl.infrastructure.repository.space.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 空间场所对象 t_safe_space
 * 
 * @author testor-framework
 * @date 2022-06-27 16:56:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_space")
@ApiModel(value = "TSafeSpace对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeSpaceDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value="id", type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;
/**
 * 车间/场所类型id
 */
  @ApiModelProperty(value = "车间/场所类型id")

  @TableField("space_type_id")
  private String spaceTypeId;
/**
 * 车间/场所名称id(level=1时，此值位空)
 */
  @ApiModelProperty(value = "车间/场所名称id(level=1时，此值位空)")

  @TableField("space_id")
  private String spaceId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称")

  @TableField("name")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")

  @TableField("code")
  private String code;
/**
 * 等级(1-车间场所名称；2-作业区域)
 */
  @ApiModelProperty(value = "等级(1-车间场所名称；2-作业区域)" , example = "0")

  @TableField("\"level\"")
  private Integer level;

//  // 设置编码值
//  public void setCode(String code) {
//    if(!StrUtil.isBlank(code)) {
//      this.code = code;
//      return;
//    }
//
//    if(getLevel() == 1) {
//      this.code = generateCode.generateWorkshopCode(getOrgId(), getSpaceTypeId());
//      return;
//    }
//
//    if(getLevel() == 2) {
//      this.code = generateCode.generateWorkareaCode(getSpaceId());
//      return;
//    }
//
//    this.code = code;
//  }


  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String SPACE_TYPE_ID ="space_type_id";
  public static final String SPACE_ID ="space_id";
  public static final String NAME ="name";
  public static final String CODE ="code";
  public static final String LEVEL ="\"level\"";
}
