package com.testor.ddd.safetyControl.interfaces.model.dto.lecls;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * lec ls与风险等级关系对象 t_safe_risk_lecls_relation
 * 
 * @author testor-framework
 * @date 2022-07-27 14:12:00
 */
@Data
public class TSafeRiskLeclsRelationDTO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 1-lec;2-ls

 */
  @ApiModelProperty(value = "1-lec;2-ls " , example = "0")
  private Integer type;
/**
 * 1-采用范围值，2-采用具体值

 */
  @ApiModelProperty(value = "1-采用范围值，2-采用具体值 " , example = "0")
  private Integer valueType;
/**
 * 最大值
 */
  @ApiModelProperty(value = "最大值" , example = "0")
  private Float maxValue;
/**
 * 最小值
 */
  @ApiModelProperty(value = "最小值" , example = "0")
  private Float minValue;

  /**
   * 现实风险
   */
  @ApiModelProperty(value = "表达式，后端使用")
  private String formulaStr;

/**
 * 具体值
 */
  @ApiModelProperty(value = "具体值" , example = "0")
  private Float value;
/**
 * 现实风险
 */
  @ApiModelProperty(value = "现实风险")
  private String realLevel;
/**
 * 是否包含最大值（0-不包含，1-包含）
 */
  @ApiModelProperty(value = "是否包含最大值（0-不包含，1-包含）")
  private String isIncludeMax;
/**
 * 是否包含最小值（0-不包含，1-包含）
 */
  @ApiModelProperty(value = "是否包含最小值（0-不包含，1-包含）")
  private String isIncludeMin;

  /**
   * 现实风险 key
   */
  @ApiModelProperty(value = "如 1,2")
  private String realLevelKey;

  /**
   * 现实风险 value
   */
  @ApiModelProperty(value = "如: 1级/2级")
  private String realLevelValue;
}
