package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 开工准备对象 t_contractor_preparation
 * 
 * @author testor-framework
 * @date 2024-11-24 13:19:04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_preparation")
@ApiModel(value = "TContractorPreparation对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorPreparation extends SuperModel
{
  private static final long serialVersionUID = 1L;
  /**
   * 主键ID
   */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
  /**
   * 承包商台账id
   */
  @ApiModelProperty(value = "承包商台账id")

  @TableField("contractor_id")
  private String contractorId;
  /**
   * 项目id
   */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
  /**
   * 流程实例ID
   */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
  /**
   * 流程状态
   */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
  /**
   * 业务id(标识是一条基本信息产生的关系)
   */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;
  /**
   * 计划开始时间
   */
  @ApiModelProperty(value = "计划开始时间")

  @TableField("plan_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date planStartTime;
  /**
   * 计划结束时间
   */
  @ApiModelProperty(value = "计划结束时间")

  @TableField("plan_end_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date planEndTime;
  /**
   * 施工项目描述
   */
  @ApiModelProperty(value = "施工项目描述")

  @TableField("construction_project_desc")
  private String constructionProjectDesc;
  /**
   * 施工地点
   */
  @ApiModelProperty(value = "施工地点")

  @TableField("construction_location")
  private String constructionLocation;
  /**
   * 承包商项目经理
   */
  @ApiModelProperty(value = "承包商项目经理id")

  @TableField("person_id")
  private String personId;
  /**
   * 承包商项目经理
   */
  @ApiModelProperty(value = "承包商项目经理")

  @TableField("project_manager")
  private String projectManager;
  /**
   * 手机号
   */
  @ApiModelProperty(value = "手机号")

  @TableField("phone")
  private String phone;
  /**
   * 施工方案
   */
  @ApiModelProperty(value = "施工方案")

  @TableField("construction_scheme")
  private String constructionScheme;
  /**
   * 应急预案
   */
  @ApiModelProperty(value = "应急预案")

  @TableField("contingency_plan")
  private String contingencyPlan;
  /**
   * 施工人员职业健康安全告知书
   */
  @ApiModelProperty(value = "施工人员职业健康安全告知书")

  @TableField("safety_notify")
  private String safetyNotify;
  /**
   * 施工人员安全承诺
   */
  @ApiModelProperty(value = "施工人员安全承诺")

  @TableField("safety_pledge")
  private String safetyPledge;

  /**
   * 驳回意见
   */
  @ApiModelProperty(value = "驳回意见")
  @TableField("reject_opinion")
  private String rejectOpinion;

  /**
   * 所属企业id
   */
  @ApiModelProperty(value = "所属企业id")

  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String BIZ_ID ="biz_id";
  public static final String PLAN_START_TIME ="plan_start_time";
  public static final String PLAN_END_TIME ="plan_end_time";
  public static final String CONSTRUCTION_PROJECT_DESC ="construction_project_desc";
  public static final String CONSTRUCTION_LOCATION ="construction_location";
  public static final String PROJECT_MANAGER ="project_manager";
  public static final String PHONE ="phone";
  public static final String CONSTRUCTION_SCHEME ="construction_scheme";
  public static final String CONTINGENCY_PLAN ="contingency_plan";
  public static final String SAFETY_NOTIFY ="safety_notify";
  public static final String SAFETY_PLEDGE ="safety_pledge";
  public static final String REJECT_OPINION ="reject_opinion";
  public static final String ORG_ID ="org_id";


}
