package com.testor.module.emergency.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 应急物资对象 t_emergency_goods
 *
 * @author testor-framework
 * @date 2022-10-08 17:31:31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_emergency_goods")
@ApiModel(value = "TEmergencyGoods对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TEmergencyGoods extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")

    @TableId("id")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;
    /**
     * 物资类型(数据字典key)
     */
    @ApiModelProperty(value = "物资类型(数据字典id)")
    @TableField("goods_type_key")
    private String goodsTypeKey;
    /**
     * 物资名称(数据字典key)
     */
    @ApiModelProperty(value = "物资名称(数据字典id)")
    @TableField("name_key")
    private String nameKey;
    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")

    @TableField("code")
    private String code;
    /**
     * 是否为消耗品 0 -否,1-是
     */
    @ApiModelProperty(value = " 是否为消耗品 0 -否,1-是")

    @TableField("consumables")
    private String consumables;
    /**
     * 规格型号
     */
    @ApiModelProperty(value = "规格型号")

    @TableField("specification")
    private String specification;
    /**
     * 应备数量
     */
    @ApiModelProperty(value = "应备数量", example = "0")
    @TableField("reserve_num")
    private Integer reserveNum;
    /**
     * 实备数量
     */
    @ApiModelProperty(value = "实备数量", example = "0")
    @TableField("practical_num")
    private Integer practicalNum;
    /**
     * 待维修数量
     */
    @ApiModelProperty(value = "待维修数量", example = "0")
    @TableField("awaiting_repair_num")
    private Integer awaitingRepairNum = 0;
    /**
     * 有效日期
     */
    @ApiModelProperty(value = "有效日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField("validity_start_date")
    private Date validityStartDate;
    /**
     * 有效日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "有效日期")
    @TableField("validity_end_date")
    private Date validityEndDate;
    /**
     * 备注描述
     */
    @ApiModelProperty(value = "备注描述")

    @TableField("des")
    private String des;

    /**
     * 备注描述
     */
    @ApiModelProperty(value = "点检周期(天)")

    @TableField("cycle")
    private Integer cycle;

    /**
     * 备注描述
     */
    @ApiModelProperty(value = "下次点检时间")
    @TableField("next_check_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date nextCheckTime;

    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String GOODS_TYPE_ID = "goods_type_id";
    public static final String NAME_ID = "name_id";
    public static final String CODE = "code";
    public static final String CONSUMABLES = "consumables";
    public static final String SPECIFICATION = "specification";
    public static final String RESERVE_NUM = "reserve_num";
    public static final String VALIDITY_START_DATE = "validity_start_date";
    public static final String VALIDITY_END_DATE = "validity_end_date";
    public static final String DES = "des";


}
