package com.testor.module.fives.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 5s工具运用改善案例对象 t_fives_tool_case
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:52
 */
@Data
@ApiModel(value = "TFivesToolCaseDTO 对象", description = "")
public class TFivesToolCaseDTO {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;
    /**
     * 案例分类（字典配置）
     */
    @ApiModelProperty(value = "案例分类（字典配置）")
    private String caseType;
    /**
     * 提案名称
     */
    @ApiModelProperty(value = "提案名称")
    private String caseName;
    /**
     * 推荐理由
     */
    @ApiModelProperty(value = "推荐理由")
    private String recommendReason;
    /**
     * 问题描述
     */
    @ApiModelProperty(value = "问题描述")
    private String problemDes;
    /**
     * 改善说明
     */
    @ApiModelProperty(value = "改善说明")
    private String improveDes;
    /**
     * 改善前图片
     */
    @ApiModelProperty(value = "改善前图片")
    private String image1;
    /**
     * 改善后图片
     */
    @ApiModelProperty(value = "改善后图片")
    private String image2;

    @ApiModelProperty(value = "流程实例id")
    private String processId;


}
