package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 安全条件确认对象 t_hazard_condition_confirmation
 * 
 * @author testor-framework
 * @date 2024-12-24 21:53:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_condition_confirmation")
@ApiModel(value = "THazardConditionConfirmation对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardConditionConfirmation extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 危险作业计划id
 */
  @ApiModelProperty(value = "危险作业计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 作业类型id
 */
  @ApiModelProperty(value = "作业类型id")

  @TableField("work_type_id")
  private String workTypeId;
  /**
   * 条件作业类型
   */
  @ApiModelProperty(value = "条件作业类型")

  @TableField("type")
  private String type;
  /**
   * 安全管理部门签字
   */
  @ApiModelProperty(value = "安全管理部门人员")

  @TableField("department")
  private String department;

/**
 * 安全管理部门签字
 */
  @ApiModelProperty(value = "安全管理部门签字")

  @TableField("department_signature")
  private String departmentSignature;
/**
 * 现场图片
 */
  @ApiModelProperty(value = "现场图片")

  @TableField("site_image")
  private String siteImage;
/**
 * 作业现场负责人签名
 */
  @ApiModelProperty(value = "作业现场负责人签名")

  @TableField("work_site_responsible_signature")
  private String workSiteResponsibleSignature;
/**
 * 签字时间
 */
  @ApiModelProperty(value = "签字时间")

  @TableField("signature_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signatureTime;

  /**
   * 流程id
   */
  @ApiModelProperty(value = "流程id")
  @TableField("process_id")
  private String processId;

  /**
   * 流程状态
   */
  @ApiModelProperty(value = "流程状态")
  @TableField("process_status")
  private String processStatus;

  /**
   * 批次（第几次安全确认）
   */
  @ApiModelProperty(value = "批次（第几次安全确认）")
  @TableField("batch")
  private Integer batch;

  /**
   * 批次（第几次安全确认）
   */
  @ApiModelProperty(value = "确认结束时间")
  @TableField("confirmation_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmationStartTime;

  /**
   * 批次（第几次安全确认）
   */
  @ApiModelProperty(value = "确认结束时间")
  @TableField("confirmation_end_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmationEndTime;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String WORK_TYPE_ID ="work_type_id";
  public static final String DEPARTMENT_SIGNATURE ="department_signature";
  public static final String SITE_IMAGE ="site_image";
  public static final String WORK_SITE_RESPONSIBLE_SIGNATURE ="work_site_responsible_signature";
  public static final String SIGNATURE_TIME ="signature_time";
  public static final String BATCH ="batch";


}
