package com.testor.module.hazard.service.impl;

import com.testor.module.hazard.dao.HazardWorkPlanStatisticsDao;
import com.testor.module.hazard.model.dto.HazardWorkPlanStatisticsDto;
import com.testor.module.hazard.model.vo.HazardWorkPlanStatisticsVO;
import com.testor.module.hazard.service.HazardWorkPlanStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class HazardWorkPlanStatisticsServiceImpl implements HazardWorkPlanStatisticsService {
    @Autowired
    private HazardWorkPlanStatisticsDao hazardWorkPlanStatisticsDao;

    /**
     * 危险作业分布统计，根据单位
     *
     * @param param
     * @return
     */
    @Override
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByOrg(HazardWorkPlanStatisticsDto param) {
        return hazardWorkPlanStatisticsDao.statWorkPlanNumByOrg(param);
    }

    /**
     * 危险作业数量统计，根据时间
     *
     * @param param
     * @return
     */
    @Override
    public List<HazardWorkPlanStatisticsVO> statWorkPlanNumByTime(HazardWorkPlanStatisticsDto param) {
        return hazardWorkPlanStatisticsDao.statWorkPlanNumByTime(param);
    }

    /**
     * 相关方作业统计
     *
     * @param param
     * @return
     */
    @Override
    public List<HazardWorkPlanStatisticsVO> statStakeholderWorkNum(HazardWorkPlanStatisticsDto param) {
        return hazardWorkPlanStatisticsDao.statStakeholderWorkNum(param);
    }

    /**
     * 租赁库占比统计
     *
     * @param param
     * @return
     */
    @Override
    public List<HazardWorkPlanStatisticsVO> statIsRentNum(HazardWorkPlanStatisticsDto param) {
        return hazardWorkPlanStatisticsDao.statIsRentNum(param);
    }

    /**
     * 危险作业人员统计
     *
     * @param param
     * @return
     */
    @Override
    public List<HazardWorkPlanStatisticsVO> statOperatorNum(HazardWorkPlanStatisticsDto param) {
        return hazardWorkPlanStatisticsDao.statOperatorNum(param);
    }
}
