package com.testor.module.hazard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.module.hazard.dao.TContractorAccessLogDao;
import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.dto.TContractorAccessLogParam;
import com.testor.module.hazard.model.dto.THazardWorkPlanParam;
import com.testor.module.hazard.service.TContractorAccessLogService;
import com.testor.module.iam.service.SysUserService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service
public class TContractorAccessLogServiceImpl extends SuperServiceImpl<TContractorAccessLogDao, TContractorAccessLog> implements TContractorAccessLogService{

    @Autowired
    private SysUserService userService;

    @Override
    public List<TContractorAccessLog> insertBatchContractorAccessLog(List<TContractorAccessLog> tContractorAccessLogs) {
        if (tContractorAccessLogs == null || tContractorAccessLogs.isEmpty()) {
            return new ArrayList<>();
        }

        // 保持原有逻辑
        this.saveBatch(tContractorAccessLogs);

        // 直接返回传入的对象（此时对象中已经包含了您自己填充的主键）
        return tContractorAccessLogs;
    }

    @Override
    public Page<TContractorAccessLog> queryContractorAccessLog(TContractorAccessLogParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TContractorAccessLog> resultPage = new Page<>(page, limit); // 修改此处泛型类型
        QueryWrapper<TContractorAccessLog> queryWrapper = this.createQuery(param);
        Page<TContractorAccessLog> tContractorAccessLogPage = this.page(resultPage, queryWrapper);
        // 关联查询创建人姓名
        tContractorAccessLogPage.getRecords().forEach(log -> {
            SysUser user = userService.getById(log.getCreateBy());
            if(null != user){
                log.setCreateByName(user.getUserName());
            }
        });
        return tContractorAccessLogPage;
    }

    @Override
    public String getMaxBatch(String contractorAllowId) {
        return baseMapper.getMaxBatch(contractorAllowId);
    }


    private QueryWrapper<TContractorAccessLog> createQuery(TContractorAccessLogParam queryParam) {
        QueryWrapper<TContractorAccessLog> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getContractorAllowId())) {
            queryWrapper.like("contractor_allow_id", queryParam.getContractorAllowId());
        }
        queryWrapper.orderByDesc("create_date","batch" );
        return queryWrapper;
    }
}
