package com.testor.module.safe.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.safe.model.domain.TSafeHazardOption;
import com.testor.module.safe.model.dto.TSafeHazardOptionDelParam;
import com.testor.module.safe.model.dto.TSafeHazardOptionParam;
import com.testor.module.safe.service.TSafeHazardOptionService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 隐患巡检排查标准细则Controller
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:44
 */
@RestController
@RequestMapping("/module/option")
@Api(value = "TSafeHazardOption", tags = "隐患巡检排查标准细则")
@Slf4j
public class TSafeHazardOptionController extends SuperController {
    @Autowired
    private TSafeHazardOptionService tSafeHazardOptionService;

    /* Generated Method*/
    @ApiOperation(value = "新增 隐患巡检排查标准细则", notes = "Add TSafeHazardOption")
    @PostMapping(value = "/add")
    public BaseResponse<TSafeHazardOption> addEntity(@RequestBody TSafeHazardOption addRequest) {
        BaseResponse<TSafeHazardOption> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TSafeHazardOption data = BeanHelper.beanToBean(addRequest, TSafeHazardOption.class);
            data.setId(id);
            boolean result = tSafeHazardOptionService.save(data);
            if (result) {
                TSafeHazardOption newEntity = new TSafeHazardOption();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 隐患巡检排查标准细则 ", notes = "Get TSafeHazardOption By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TSafeHazardOption> getById(String id) {
        BaseResponse<TSafeHazardOption> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TSafeHazardOption data = tSafeHazardOptionService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 隐患巡检排查标准细则 ", notes = "Update TSafeHazardOption By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeHazardOption updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeHazardOption data = BeanHelper.beanToBean(updateRequest, TSafeHazardOption.class);
            boolean result = tSafeHazardOptionService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 隐患巡检排查标准细则 ", notes = "delete TSafeHazardOption By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardOptionDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeHazardOption data = new TSafeHazardOption();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tSafeHazardOptionService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除隐患巡检排查标准细则", notes = "delete TSafeHazardOption by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TSafeHazardOptionDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TSafeHazardOption> tSafeHazardOptionList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TSafeHazardOption data = new TSafeHazardOption();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tSafeHazardOptionList.add(data);
            }
            boolean result = tSafeHazardOptionService.updateBatchById(tSafeHazardOptionList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 隐患巡检排查标准细则 分页列表", notes = "List TSafeHazardOption with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TSafeHazardOption>> listEntity(TSafeHazardOptionParam param) {
        BaseResponse<BaseResponseList<TSafeHazardOption>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeHazardOption> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TSafeHazardOption> queryWrapper = this.createQuery(param);
        Page<TSafeHazardOption> resultList = tSafeHazardOptionService.page(resultPage, queryWrapper);
        BaseResponseList<TSafeHazardOption> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 隐患巡检排查标准细则 列表", notes = "List TSafeHazardOption all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TSafeHazardOption>> listAllEntity(TSafeHazardOptionParam param) {
        BaseResponse<BaseResponseList<TSafeHazardOption>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TSafeHazardOption> queryWrapper = this.createQuery(param);
        List<TSafeHazardOption> resultList = tSafeHazardOptionService.list(queryWrapper);
        BaseResponseList<TSafeHazardOption> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeHazardOption> createQuery(TSafeHazardOptionParam queryParam) {
        QueryWrapper<TSafeHazardOption> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TSafeHazardOption.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TSafeHazardOption.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TSafeHazardOption.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TSafeHazardOption.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TSafeHazardOption.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckName())) {
            queryWrapper.like(TSafeHazardOption.CHECK_NAME, queryParam.getCheckName());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckType())) {
            queryWrapper.eq(TSafeHazardOption.CHECK_TYPE, queryParam.getCheckType());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckId())) {
            queryWrapper.eq(TSafeHazardOption.CHECK_ID, queryParam.getCheckId());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckContent())) {
            queryWrapper.eq(TSafeHazardOption.CHECK_CONTENT, queryParam.getCheckContent());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckMethod())) {
            queryWrapper.eq(TSafeHazardOption.CHECK_METHOD, queryParam.getCheckMethod());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeHazardOption.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeHazardOption.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TSafeHazardOption.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
