package com.testor.module.safe.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.module.safe.model.domain.TSafeHazardOrg;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 隐患上报台账 删除参数对象
 *
 * @author testor-framework
 * @date 2022-08-04 14:01:01
 */

@Data
@ApiModel(value = "TSafeHazardOrg 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeHazardOrgParam extends TSafeHazardOrg {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "企业选择")
    private List<String> condOrgIdList;

    @ApiModelProperty(value = "流程状态 查询时传入")
    private List<String> processStatusList;

    @ApiModelProperty(value = "流程状态 查询时传入(不包含的状态)")
    private List<String> processNotInStatusList;

    @ApiModelProperty(value = "上报开始时间")
    private String startTime;

    @ApiModelProperty(value = "上报结束时间")
    private String endTime;

    @ApiModelProperty(value = "本下级所有orgid")
    private List<String> orgIds;

    @ApiModelProperty(value = "安全检查任务id")
    private String taskId;

    @ApiModelProperty(value = "安全检查计划id")
    private String planId;

    @ApiModelProperty
    @TableField(exist = false)
    private String userId;

    @ApiModelProperty(value = "条件类型")
    private String conditionType;

    @ApiModelProperty(value = "本机构数据")
    private boolean thisOrg;

    @ApiModelProperty("ids")
    private List<String> ids;
}
