package com.testor.module.threeframework.service;


import com.testor.module.threeframework.model.domain.TThreeTimeAuxiliary;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 三同时管理附件Service接口
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:21
 */
public interface TThreeTimeAuxiliaryService extends SuperService<TThreeTimeAuxiliary> {

    /**
     * 获取具体的项目进度附件
     *
     * @param parentId 父级ID
     * @param plan     项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）
     * @return
     */
    List<TThreeTimeAuxiliary> getThreeTimeAuxiliaryByPlan(String parentId, String plan);

    /**
     * 获取具体的项目进度附件
     *
     * @param parentId 父级ID
     * @param plan     项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）
     * @param type     附件类型（例：评价报告、附件及批复文件：safetyEvaluation），其他相关资料传入：rests
     * @return
     */
    TThreeTimeAuxiliary getThreeTimeAuxiliaryByPlan(String parentId, String plan, String type);

}
