package com.testor.module.train.exam.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.dict.data.controller.SysDictDataController;
import com.testor.module.train.exam.model.domain.TTrainTestQuestions;
import com.testor.module.train.exam.model.dto.TTrainTestQuestionsDelParam;
import com.testor.module.train.exam.model.dto.TTrainTestQuestionsParam;
import com.testor.module.train.exam.service.TTrainTestQuestionsService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.List;

/**
 * 管理试题——教育培训Controller
 *
 * @author testor-framework
 * @date 2022-07-13 15:22:00
 */
@RestController
@RequestMapping("/questions")
@Api(value = "TTrainTestQuestions", tags = "安全培训教育——管理试题")
@Slf4j
public class TTrainTestQuestionsController extends SuperController {
    @Autowired
    private TTrainTestQuestionsService tTrainTestQuestionsService;

    @ApiOperation(value = "导入试题", notes = "")
    @PostMapping("/import")
    public BaseResponse<TTrainTestQuestions> imports(@RequestParam("file") MultipartFile file, TTrainTestQuestions tTrainTestQuestions) throws Exception {
        return tTrainTestQuestionsService.imports(file, tTrainTestQuestions);
    }

    /* Generated Method*/
    @ApiOperation(value = "新增或者修改 管理试题——教育培训", notes = "添加时必传 题库questionBankId  题库名称")
    @PostMapping(value = "/add")
    public BaseResponse<TTrainTestQuestions> addEntity(@RequestBody TTrainTestQuestionsParam addRequest) throws Exception {
        return tTrainTestQuestionsService.addEntity(addRequest);
    }

    @ApiOperation(value = "获取 管理试题——教育培训 ", notes = "Get TTrainTestQuestions By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TTrainTestQuestions> getById(String id) throws Exception {
        return tTrainTestQuestionsService.getByIds(id);
    }

    //    @ApiOperation(value = "修改 管理试题——教育培训 ", notes = "Update TTrainTestQuestions By Id")
//    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TTrainTestQuestions updateRequest) throws Exception {
        return tTrainTestQuestionsService.updateEntity(updateRequest);
    }

    @ApiOperation(value = "删除 管理试题——教育培训 ", notes = "delete TTrainTestQuestions By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TTrainTestQuestionsDelParam deleteRequest) throws Exception {
        return tTrainTestQuestionsService.deleteEntity(deleteRequest);
    }

    //    @ApiOperation(value = "批量删除管理试题——教育培训", notes = "delete TTrainTestQuestions by batch Id")
//    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TTrainTestQuestionsDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TTrainTestQuestions> tTrainTestQuestionsList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TTrainTestQuestions data = new TTrainTestQuestions();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tTrainTestQuestionsList.add(data);
            }
            boolean result = tTrainTestQuestionsService.updateBatchById(tTrainTestQuestionsList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 管理试题——教育培训 分页列表", notes = "获取试题列表需要传题库id")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TTrainTestQuestionsParam>> listEntity(TTrainTestQuestionsParam param) {
        BaseResponse<BaseResponseList<TTrainTestQuestionsParam>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TTrainTestQuestions> resultPage = new Page<>(page, limit);
        QueryWrapper<TTrainTestQuestions> queryWrapper = this.createQuery(param);
        Page<TTrainTestQuestions> resultList = tTrainTestQuestionsService.page(resultPage, queryWrapper);
        BaseResponseList<TTrainTestQuestionsParam> baseResponseList = new BaseResponseList<>();
        List<TTrainTestQuestions> records = resultList.getRecords();
        List<TTrainTestQuestionsParam> questionsParamList = converDict(records);
        baseResponseList.setData(questionsParamList);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /**
     * 转字典值
     *
     * @param baseResponseList
     * @return
     */
    @Autowired
    private SysDictDataController sysDictDataController;

    private List<TTrainTestQuestionsParam> converDict(List<TTrainTestQuestions> baseResponseList) {
        List<TTrainTestQuestionsParam> data1 = new ArrayList<>();
        for (TTrainTestQuestions datum : baseResponseList) {
            TTrainTestQuestionsParam tTrainDatabase = BeanHelper.beanToBean(datum, TTrainTestQuestionsParam.class);
            String secondSubject = tTrainDatabase.getTestQuestionsType();
            String subject_level = sysDictDataController.getDictTypeDetail("", "TEST_QUESTIONS_TYPE", secondSubject).getData().getDictValue();
            tTrainDatabase.setDictValue(subject_level);
            tTrainDatabase.setTestQuestionsType(secondSubject);
            data1.add(tTrainDatabase);
        }
        return data1;
    }
    //    @ApiOperation(value = "获取 管理试题——教育培训 列表", notes = "List TTrainTestQuestions all")
//    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TTrainTestQuestions>> listAllEntity(TTrainTestQuestionsParam param) {
        BaseResponse<BaseResponseList<TTrainTestQuestions>> baseResponse = new BaseResponse<>();
        QueryWrapper<TTrainTestQuestions> queryWrapper = this.createQuery(param);
        List<TTrainTestQuestions> resultList = tTrainTestQuestionsService.list(queryWrapper);
        BaseResponseList<TTrainTestQuestions> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TTrainTestQuestions> createQuery(TTrainTestQuestionsParam queryParam) {
        QueryWrapper<TTrainTestQuestions> queryWrapper = new QueryWrapper<>();
        //需要传 题库id
        String questionBankId = queryParam.getQuestionBankId();
        queryWrapper.orderByDesc(TTrainTestQuestions.CREATE_DATE);
        queryWrapper.eq(TTrainTestQuestions.QUESTION_BANK_ID, questionBankId);
        String startDateTime = queryParam.getStartDateTime();
        String endDateTime = queryParam.getEndDateTime();
        if (StringHelper.isNotEmpty(startDateTime) && StringHelper.isNotEmpty(endDateTime)) {
            queryWrapper.between(TTrainTestQuestions.CREATE_DATE, startDateTime+" 00:00:00", endDateTime+" 23:59:59");
        }
        if (StringHelper.isNotEmpty(queryParam.getTestQuestionsType())) {
            queryWrapper.eq(TTrainTestQuestions.TEST_QUESTIONS_TYPE, queryParam.getTestQuestionsType());
        }
        if (StringHelper.isNotEmpty(queryParam.getQuestionBankName())) {
            queryWrapper.like(TTrainTestQuestions.QUESTION_BANK_NAME, queryParam.getQuestionBankName());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TTrainTestQuestions.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TTrainTestQuestions.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TTrainTestQuestions.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
