/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.bean.requestv2;

import com.tongweb.commons.license.bean.requestv2.BaseRequest;
import com.tongweb.commons.utils.StringUtils;
import java.io.Serializable;

public class TokenBody
extends BaseRequest
implements Serializable {
    private static final long serialVersionUID = 5963197337999906017L;
    private String mac;
    private String hostname;
    private String core;
    private String ip;
    private String tongwebEdition;
    private String tongWebName = "TongWeb";

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getCore() {
        return this.core;
    }

    public void setCore(String core) {
        this.core = core;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getTongwebEdition() {
        return this.tongwebEdition;
    }

    public void setTongwebEdition(String tongwebEdition) {
        this.tongwebEdition = tongwebEdition;
    }

    public String getTongWebName() {
        return this.tongWebName;
    }

    public void setTongWebName(String tongWebName) {
        if (StringUtils.isNotEmpty(tongWebName)) {
            this.tongWebName = tongWebName;
        }
    }

    public static final class Builder {
        private String mac;
        private String hostname;
        private String core;
        private String ip;
        private String versionNumber;
        private String tongwebEdition;
        private String tongwebName;
        private long timestamp;
        private String sign;
        private String licenseId;
        private String ext;

        public static Builder aTokenBody() {
            return new Builder();
        }

        public Builder mac(String mac) {
            this.mac = mac;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder core(String core) {
            this.core = core;
            return this;
        }

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder tongwebEdition(String val) {
            this.tongwebEdition = val;
            return this;
        }

        public Builder tongwebName(String val) {
            this.tongwebName = val;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder sign(String sign) {
            this.sign = sign;
            return this;
        }

        public Builder licenseId(String licenseId) {
            this.licenseId = licenseId;
            return this;
        }

        public Builder ext(String ext) {
            this.ext = ext;
            return this;
        }

        public TokenBody build() {
            TokenBody tokenBody = new TokenBody();
            tokenBody.setMac(this.mac);
            tokenBody.setHostname(this.hostname);
            tokenBody.setCore(this.core);
            tokenBody.setIp(this.ip);
            tokenBody.setVersionNumber(this.versionNumber);
            tokenBody.setTongwebEdition(this.tongwebEdition);
            tokenBody.setTongWebName(this.tongwebName);
            tokenBody.setTimestamp(this.timestamp);
            tokenBody.setSign(this.sign);
            tokenBody.setLicenseId(this.licenseId);
            tokenBody.setExt(this.ext);
            return tokenBody;
        }
    }
}

