/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dv2.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.dv2.VisualEnumCode;
import com.tongtech.tfw.dv2.model.domain.BladeVisualCategory;
import com.tongtech.tfw.dv2.model.dto.BladeVisualCategoryDelParam;
import com.tongtech.tfw.dv2.model.dto.BladeVisualCategoryParam;
import com.tongtech.tfw.dv2.service.BladeVisualCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/visual/category"})
@Api(value="BladeVisualCategory", tags={"\u53ef\u89c6\u5316\u5206\u7c7b"})
public class BladeVisualCategoryController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(BladeVisualCategoryController.class);
    @Autowired
    private BladeVisualCategoryService bladeVisualCategoryService;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316\u5206\u7c7b", notes="Add BladeVisualCategory")
    @PostMapping(value={"/save"})
    public BaseResponse<BladeVisualCategory> addEntity(@RequestBody BladeVisualCategory addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            String id = IdHelper.getId32bit();
            List tDataviewCategory = this.bladeVisualCategoryService.list((Wrapper)new QueryWrapper().lambda().eq(BladeVisualCategory::getCategoryKey, (Object)addRequest.getCategoryKey()));
            if (!tDataviewCategory.isEmpty()) {
                throw new ApiException(VisualEnumCode.CATEGORY_EXISTED.transform());
            }
            BladeVisualCategory data = (BladeVisualCategory)BeanHelper.beanToBean((Object)addRequest, BladeVisualCategory.class);
            data.setId(id);
            boolean result = this.bladeVisualCategoryService.save(data);
            if (result) {
                BladeVisualCategory newEntity = new BladeVisualCategory();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b ", notes="Get BladeVisualCategory By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<BladeVisualCategory> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            BladeVisualCategory data = (BladeVisualCategory)this.bladeVisualCategoryService.getById((Serializable)((Object)id));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @GetMapping(value={"/detail"})
    @ApiOperationSupport(order=1)
    @ApiOperation(value="\u8be6\u60c5", notes="\u4f20\u5165visualCategory")
    public BaseResponse<BladeVisualCategory> detail(BladeVisualCategoryParam visualCategory) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)visualCategory)) {
            QueryWrapper<BladeVisualCategory> queryWrapper = this.createQuery(visualCategory);
            BladeVisualCategory detail = (BladeVisualCategory)this.bladeVisualCategoryService.getOne((Wrapper)queryWrapper);
            baseResponse.setData((Object)detail);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316\u5206\u7c7b ", notes="Update BladeVisualCategory By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody BladeVisualCategory updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            BladeVisualCategory data = (BladeVisualCategory)BeanHelper.beanToBean((Object)updateRequest, BladeVisualCategory.class);
            List tDataviewCategory = this.bladeVisualCategoryService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(BladeVisualCategory::getId, (Object)updateRequest.getId())).eq(BladeVisualCategory::getCategoryKey, (Object)updateRequest.getCategoryKey()));
            if (!tDataviewCategory.isEmpty()) {
                throw new ApiException(VisualEnumCode.CATEGORY_EXISTED.transform());
            }
            boolean result = this.bladeVisualCategoryService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316\u5206\u7c7b ", notes="delete BladeVisualCategory By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody BladeVisualCategoryDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            BladeVisualCategory data = new BladeVisualCategory();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.bladeVisualCategoryService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u5206\u7c7b", notes="delete BladeVisualCategory by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody BladeVisualCategoryDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<BladeVisualCategory> bladeVisualCategoryList = new ArrayList<BladeVisualCategory>();
            for (String id : deleteRequest.getIds()) {
                BladeVisualCategory data = new BladeVisualCategory();
                data.setId(id);
                data.setStatus("1");
                bladeVisualCategoryList.add(data);
            }
            boolean result = this.bladeVisualCategoryService.updateBatchById(bladeVisualCategoryList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u5220\u9664", notes="delete BladeVisual by batch Id")
    public BaseResponse<BizGeneralResponse> remove(@RequestParam String ids) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotBlank((CharSequence)ids)) {
            List idList = CollectionHelper.arrayToList((Object)StringHelper.split((String)ids, (String)","));
            ArrayList<BladeVisualCategory> deleteList = new ArrayList<BladeVisualCategory>(idList.size());
            for (String id : idList) {
                BladeVisualCategory bladeVisual = new BladeVisualCategory();
                bladeVisual.setId(id);
                bladeVisual.setStatus("1");
                deleteList.add(bladeVisual);
            }
            boolean result = this.bladeVisualCategoryService.updateBatchById(deleteList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b \u5206\u9875\u5217\u8868", notes="List BladeVisualCategory with page")
    @GetMapping(value={"/page"})
    public BaseResponse<BaseResponseList<BladeVisualCategory>> listEntity(BladeVisualCategoryParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<BladeVisualCategory> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.bladeVisualCategoryService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5206\u7c7b \u5217\u8868", notes="List BladeVisualCategory all")
    @GetMapping(value={"/list"})
    public BaseResponse<List<BladeVisualCategory>> listAllEntity(BladeVisualCategoryParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<BladeVisualCategory> queryWrapper = this.createQuery(param);
        List resultList = this.bladeVisualCategoryService.list((Wrapper)queryWrapper);
        baseResponse.setData((Object)resultList);
        return baseResponse;
    }

    private QueryWrapper<BladeVisualCategory> createQuery(BladeVisualCategoryParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getId())) {
            queryWrapper.eq((Object)"id", (Object)queryParam.getId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCategoryKey())) {
            queryWrapper.eq((Object)"category_key", (Object)queryParam.getCategoryKey());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCategoryValue())) {
            queryWrapper.eq((Object)"category_value", (Object)queryParam.getCategoryValue());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getIsDeleted())) {
            queryWrapper.eq((Object)"is_deleted", (Object)queryParam.getIsDeleted());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"id");
        }
        return queryWrapper;
    }
}

