/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.rule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.rule.RuleTypeEunm;
import com.testor.biz.rule.dao.SysRuleDao;
import com.testor.biz.rule.model.domain.SysRule;
import com.testor.biz.rule.service.SysRuleService;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysRuleServiceImpl
extends SuperServiceImpl<SysRuleDao, SysRule>
implements SysRuleService {
    private static final Logger log = LoggerFactory.getLogger(SysRuleServiceImpl.class);
    @Autowired(required=false)
    private SysRuleDao sysRuleDao;
    @Autowired
    private SysUserService sysUserService;

    @Override
    public String dataRuleScope(String ruleCode) {
        SysRule sysRule;
        String sqlTemplate = "";
        if (StringHelper.isNotEmpty((CharSequence)ruleCode) && ObjectHelper.isNotEmpty((Object)((Object)(sysRule = (SysRule)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"rule_code", (Object)ruleCode)).ne((Object)"status", (Object)"1"))))))) {
            sqlTemplate = sysRule.getRuleSqlTemplate();
            if (StringHelper.isNotEmpty((CharSequence)sqlTemplate)) {
                if (sqlTemplate.contains("${user-id}")) {
                    sqlTemplate = sqlTemplate.replace("${user-id}", this.getUserId());
                }
                if (sqlTemplate.contains("${org-id}")) {
                    sqlTemplate = sqlTemplate.replace("${org-id}", this.getUserOrgId());
                }
                if (sqlTemplate.contains("${parent-ids}")) {
                    sqlTemplate = sqlTemplate.replace("${parent-ids}", ContextUtils.getLoginUser().getParentIds());
                }
                sqlTemplate = " " + sqlTemplate;
            } else {
                log.error("SqlTemplate is Empty : " + ruleCode);
            }
        }
        return sqlTemplate;
    }

    @Override
    public String dataRuleScope(String ruleCode, List<String> idList) {
        SysRule sysRule;
        String sqlTemplate = "";
        if (StringHelper.isNotEmpty((CharSequence)ruleCode) && !CollectionUtils.isEmpty(idList) && ObjectHelper.isNotEmpty((Object)((Object)(sysRule = (SysRule)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"rule_code", (Object)ruleCode)).ne((Object)"status", (Object)"1"))))))) {
            sqlTemplate = sysRule.getRuleSqlTemplate();
            if (StringHelper.isNotEmpty((CharSequence)sqlTemplate)) {
                if (sqlTemplate.contains("${ids}")) {
                    sqlTemplate = sqlTemplate.replace("${ids}", idList.stream().collect(Collectors.joining()));
                }
                sqlTemplate = " " + sqlTemplate;
            } else {
                log.error("SqlTemplate is Empty : " + ruleCode);
            }
        }
        return sqlTemplate;
    }

    @Override
    public SysRule generateSqlTemplate(SysRule sysRule) {
        if (ObjectHelper.isNotEmpty((Object)((Object)sysRule)) && StringHelper.isNotEmpty((CharSequence)sysRule.getRuleType())) {
            if (RuleTypeEunm.ALL.key().equals(sysRule.getRuleType())) {
                sysRule.setRuleSqlTemplate(" 1=1 ");
            } else if (RuleTypeEunm.OWN.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "user_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate(ruleDataCode + " = ${user-id}");
            } else if (RuleTypeEunm.OWN_ORG.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "org_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate(ruleDataCode + " = '${org-id}'");
            } else if (RuleTypeEunm.SUB_ORG.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "org_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate(ruleDataCode + " in (select org.org_id from t_sys_org org where org.parent_ids like '%,${org-id}%' or org.org_id = '${org-id}')");
            } else if (RuleTypeEunm.CUSTOM_ORG.key().equals(sysRule.getRuleType())) {
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataScope())) {
                    String ruleDataCode = "org_id";
                    if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                        ruleDataCode = sysRule.getRuleDataCode();
                    }
                    String dataScope = Arrays.asList(sysRule.getRuleDataScope().split(",")).stream().map(n -> "'" + n + "'").collect(Collectors.joining(","));
                    sysRule.setRuleSqlTemplate(ruleDataCode + " in (" + dataScope + ")");
                }
            } else if (RuleTypeEunm.CUSTOM.key().equals(sysRule.getRuleType())) {
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode()) && StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataOperation()) && StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataScope())) {
                    String dataScope = Arrays.asList(sysRule.getRuleDataScope().split(",")).stream().map(n -> "'" + n + "'").collect(Collectors.joining(","));
                    String sb = sysRule.getRuleDataCode() + " " + sysRule.getRuleDataOperation() + " (" + dataScope + ")";
                    sysRule.setRuleSqlTemplate(sb);
                }
            } else if (RuleTypeEunm.GROUP_DATA.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "org_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate("FIND_IN_SET ('${org-id}'," + ruleDataCode + ")");
            } else if (RuleTypeEunm.USER_DATA.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "user_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate("FIND_IN_SET ('${user-id}'," + ruleDataCode + ")");
            } else if (RuleTypeEunm.USER_DATA.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "user_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate("FIND_IN_SET ('${user-id}'," + ruleDataCode + ")");
            } else if (RuleTypeEunm.GROUP_UP.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "org_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate(ruleDataCode + " in (select org.org_id from t_sys_org org where find_in_set(org.org_id,'${parent-ids}') or org.org_id = '${org-id}')");
            } else if (RuleTypeEunm.GROUP_ALL.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "org_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate(ruleDataCode + " in (select org.org_id from t_sys_org org where find_in_set(org.org_id,'${parent-ids}') or org.parent_ids like '%,${org-id}%' or org.org_id = '${org-id}')");
            } else if (RuleTypeEunm.GROUP_CUSTOM_PARAM.key().equals(sysRule.getRuleType())) {
                String ruleDataCode = "org_id";
                if (StringHelper.isNotEmpty((CharSequence)sysRule.getRuleDataCode())) {
                    ruleDataCode = sysRule.getRuleDataCode();
                }
                sysRule.setRuleSqlTemplate(ruleDataCode + " in (select org.org_id from t_sys_org org where find_in_set(org.parent_id,'${ids}') or find_in_set(org.org_id,'${ids}'))");
            }
        }
        return sysRule;
    }

    private String getUserId() {
        String userId = ContextUtils.getLoginUserId();
        return "'" + userId + "'";
    }

    private String getUserOrgId() {
        String orgId = null;
        try {
            orgId = ContextUtils.getLoginUser().getOrgId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgId;
    }
}

