package com.testor.config.listener;

/**
 * @author wwz
 * @version 1.0.0
 * @title RedisKeyExpirationListener
 * @description <TODO description class purpose>
 * @create 2023/4/5 8:48
 */
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.testor.common.constant.NoticeConstant;
import com.testor.common.util.JsonUtils;
import com.testor.module.hazard.service.TimeoutRemindStrategy;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author: taoym
 * @date: 2020/7/23 9:38
 * @desc: 监听器
 */
@Component
@Slf4j
public class RedisMessageReceiver {

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private Map<String, TimeoutRemindStrategy> strategyMap;

    @SneakyThrows
    public void onMessage(String message) {
        String[] split = message.split("-");
        // 判断数组长度，确保可以安全地访问到元素
        if (split.length > 3) {
            String id = split[3];
            //获取key
            String key = String.join("-", split).replace("-"+id , "");
            TimeoutRemindStrategy timeoutRemindStrategy = strategyMap.get(key);
            timeoutRemindStrategy.remind(id);
        }
    }

    private String getTime(Long minutes) {
        long months = minutes / (60 * 24 * 30); // 将分钟转换为月数
        long days = (minutes % (60 * 24 * 30)) / (60 * 24); // 将剩余的分钟数转换为天数
        long hours = (minutes % (60 * 24)) / 60; // 将剩余的分钟数转换为小时数
        long remainingMinutes = minutes % 60; // 剩余的不足一小时的分钟数

        if (months > 0) {
            return "还有 " + months + " 个月";
        } else if (days > 0) {
            return "还有 " + days + " 天";
        } else if (hours > 0) {
            return "还有 " + hours + " 小时";
        } else {
            return "还有 " + remainingMinutes + " 分钟";
        }
    }

}
