package com.testor.ddd.functionConfiguration.infrastructure.repository.tableNum.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.ddd.functionConfiguration.domain.tableNum.entity.TTableNumRepo;
import com.testor.ddd.functionConfiguration.infrastructure.repository.tableNum.dao.TTableNumDao;
import com.testor.ddd.functionConfiguration.infrastructure.repository.tableNum.entity.TTableNumDO;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 记录业务最大条数Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-06-27 16:56:22
 */
@Service
public class TTableNumServiceImpl extends SuperServiceImpl<TTableNumDao, TTableNumDO> implements TTableNumRepo {
    @Autowired(required = false)
    private TTableNumDao tTableNumDao;

    public List<TTableNumDO> findList(String tableName, String fieldName){

        LambdaQueryWrapper<TTableNumDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TTableNumDO::getTableName, tableName)
                .eq(TTableNumDO::getFieldName, fieldName);
        List<TTableNumDO> tableNumDOList = tTableNumDao.selectList(queryWrapper);
        return tableNumDOList;
    }

    public boolean saveTableNum(String tableName, String fieldName, Integer maxNum){

        TTableNumDO tableNumDO = new TTableNumDO();
        tableNumDO.setTableName(tableName);
        tableNumDO.setFieldName(fieldName);
        tableNumDO.setNum(maxNum);
        return tTableNumDao.insert(tableNumDO) > 1 ? true : false;
    }

    public boolean updateTableNumByEntity(TTableNumDO tableNumDO){
        return tTableNumDao.updateById(tableNumDO) == 1 ? true : false;
    }

    /**
     * 替换 匹配的fieldName
     * @param tableName
     * @param oldFieldName
     * @param newFieldName
     */
    public Integer replaceFieldName(String tableName, String oldFieldName, String newFieldName){
        return tTableNumDao.replaceFieldName(tableName, oldFieldName, newFieldName);
    }

}
