package com.testor.ddd.safetyControl.infrastructure.repository.riskPoint.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.riskPoint.entity.TSafeRiskPointRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskPoint.dao.TSafeRiskPointDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskPoint.entity.TSafeRiskPointDO;
import com.testor.ddd.safetyControl.infrastructure.uitls.RiskRelationTypeEnum;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPoint.TSafeRiskPointDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.TSafeRiskPointVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskPointServiceImpl extends SuperServiceImpl<TSafeRiskPointDao, TSafeRiskPointDO>
        implements TSafeRiskPointRepo

{
    @Autowired(required = false)
    private TSafeRiskPointDao tSafeRiskPointDao;

    public TSafeRiskPointDTO insert(TSafeRiskPointDTO riskPointDTO){
        TSafeRiskPointDO data = BeanHelper.beanToBean(riskPointDTO, TSafeRiskPointDO.class);
        int result = tSafeRiskPointDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskPointDTO = BeanHelper.beanToBean(data, TSafeRiskPointDTO.class);
        return riskPointDTO;
    }

    public TSafeRiskPointDTO updateById(TSafeRiskPointDTO riskPointDTO){
        TSafeRiskPointDO data = BeanHelper.beanToBean(riskPointDTO, TSafeRiskPointDO.class);
        int result = tSafeRiskPointDao.updateById(data);
        if(result < 1) {
            return null;
        }
        riskPointDTO = BeanHelper.beanToBean(data, TSafeRiskPointDTO.class);
        return riskPointDTO;
    }

    /**
     * 车间场所分页查询
     * @param param
     * @return
     */
    public BaseResponseList<TSafeRiskPointVO> listPage(TSafeRiskPointDTOParam param){
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskPointVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskPointVO> iPage = tSafeRiskPointDao.listPage(resultPage, param);

        BaseResponseList<TSafeRiskPointVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }

    public TSafeRiskPointDTO findById(String id){
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskPointDO riskPointDo = tSafeRiskPointDao.selectById(id);
        TSafeRiskPointDTO riskPointDTO = BeanHelper.beanToBean(riskPointDo, TSafeRiskPointDTO.class);
        return riskPointDTO;
    }

    public boolean deleteById(String id){
        UpdateWrapper<TSafeRiskPointDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeRiskPointDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskPointDO::getStatus, BizConstants.STATUS_DELETE)
                .eq(TSafeRiskPointDO::getId,id);
        return update(updateWrapper);
    }

    /**
     *
     * @param type 1-设备; 2-空间(作业区域)；  3-空间(车间场所)；
     * @param bizId type=1-设备id; 2-空间(作业区域)id；  3-空间(车间场所)id；
     * @return
     */
    public boolean deleteBySpaceOrEquipment(Integer type, String bizId){
        if((type != 1 && type != 2 && type != 3)
                || StrUtil.isBlank(bizId)) {
            return false;
        }
        LambdaUpdateWrapper<TSafeRiskPointDO> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(TSafeRiskPointDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeRiskPointDO::getStatus, BizConstants.STATUS_DELETE);
        if(type == 1) {
            updateWrapper.eq(TSafeRiskPointDO::getRelationType, RiskRelationTypeEnum.equipment.getCode())
                    .eq(TSafeRiskPointDO::getRelationEquipmentId, bizId);
        }
        if(type == 2) {
            updateWrapper.eq(TSafeRiskPointDO::getRelationType, RiskRelationTypeEnum.space.getCode())
                    .eq(TSafeRiskPointDO::getRelationSpaceId, bizId);
        }
        if(type == 3) {
            updateWrapper.eq(TSafeRiskPointDO::getRelationType, RiskRelationTypeEnum.space.getCode())
                    .eq(TSafeRiskPointDO::getRelationSpaceParentId, bizId);
        }
        return update(updateWrapper);
    }

    public List<TSafeRiskPointDTO> listAllEntity(TSafeRiskPointDTOParam param){
        QueryWrapper<TSafeRiskPointDO> queryWrapper=this.createQuery(param);
        List<TSafeRiskPointDO> resultList=list(queryWrapper);
        List<TSafeRiskPointDTO> resultDTOList= BeanHelper.listToList(resultList, TSafeRiskPointDTO.class);
        return resultDTOList;
    }


    /* Private Methods */
    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeRiskPointDO> createQuery(TSafeRiskPointDTOParam queryParam){
        QueryWrapper<TSafeRiskPointDO> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TSafeRiskPointDO.ORG_ID,queryParam.getOrgId());
        }
        if(StringHelper.isNotEmpty(queryParam.getDepartmentId())){
            queryWrapper.eq(TSafeRiskPointDO.DEPARTMENT_ID,queryParam.getDepartmentId());
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TSafeRiskPointDO.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getCode())){
            queryWrapper.eq(TSafeRiskPointDO.CODE,queryParam.getCode());
        }
        if(StringHelper.isNotEmpty(queryParam.getTypeId())){
            queryWrapper.eq(TSafeRiskPointDO.TYPE_ID,queryParam.getTypeId());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getRelationType())){
            queryWrapper.eq(TSafeRiskPointDO.RELATION_TYPE,queryParam.getRelationType());
        }
        if(StringHelper.isNotEmpty(queryParam.getRelationEquipmentId())){
            queryWrapper.eq(TSafeRiskPointDO.RELATION_EQUIPMENT_ID,queryParam.getRelationEquipmentId());
        }
        if(StringHelper.isNotEmpty(queryParam.getRelationSpaceId())){
            queryWrapper.eq(TSafeRiskPointDO.RELATION_SPACE_ID,queryParam.getRelationSpaceId());
        }
        if(StringHelper.isNotEmpty(queryParam.getSpaceLocation())){
            queryWrapper.eq(TSafeRiskPointDO.SPACE_LOCATION,queryParam.getSpaceLocation());
        }
        if(StringHelper.isNotEmpty(queryParam.getInherentLevelId())){
            queryWrapper.eq(TSafeRiskPointDO.INHERENT_LEVEL_ID,queryParam.getInherentLevelId());
        }
        if(StringHelper.isNotEmpty(queryParam.getRealLevelId())){
            queryWrapper.eq(TSafeRiskPointDO.REAL_LEVEL_ID,queryParam.getRealLevelId());
        }

        if(StringHelper.isNotEmpty(queryParam.getControlLevelId())){
            queryWrapper.eq(TSafeRiskPointDO.CONTROL_LEVEL_ID,queryParam.getControlLevelId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeRiskPointDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeRiskPointDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TSafeRiskPointDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

    public boolean saveBatch(List<TSafeRiskPointDTO> riskPointDTOList){
        List<TSafeRiskPointDO> riskPointDOList = BeanHelper.listToList(riskPointDTOList, TSafeRiskPointDO.class);
        return saveBatch(riskPointDOList);
    }

    /**
     * 根据id查看详情
     * @param id
     * @return
     */
    public TSafeRiskPointVO findDetailById(String id) {
        if(StrUtil.isBlank(id)) {
            return null;
        }
        TSafeRiskPointDTOParam param = new TSafeRiskPointDTOParam();
        param.setStatus(BizConstants.STATUS_ENABLE);
        param.setPage("1");
        param.setLimit("1");
        param.setId(id);

        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskPointVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskPointVO> iPage = tSafeRiskPointDao.listPage(resultPage, param);
        List<TSafeRiskPointVO> riskPointVOList = iPage.getRecords();
        if(riskPointVOList == null || riskPointVOList.size() == 0) {
            return null;
        }
        TSafeRiskPointVO riskPointVO = riskPointVOList.get(0);
        return riskPointVO;
    }

    public TSafeRiskPointDTO findBySource(String sourceId){
        List<TSafeRiskPointDTO> list = tSafeRiskPointDao.findBySource(sourceId);
        if(list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    public List<TSafeRiskPointDTO> checkUniqueness(String orgId, String sourceId, String name){
        LambdaQueryWrapper<TSafeRiskPointDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeRiskPointDO::getOrgId, orgId)
                .eq(TSafeRiskPointDO::getStatus, BizConstants.STATUS_ENABLE)
                .eq(TSafeRiskPointDO::getName, name) ;
        if(!StrUtil.isBlank(sourceId)) {
            queryWrapper.ne(TSafeRiskPointDO::getId, sourceId);
        }
        List<TSafeRiskPointDO> pointDOList = tSafeRiskPointDao.selectList(queryWrapper);
        List<TSafeRiskPointDTO> pointDTOList = BeanHelper.listToList(pointDOList, TSafeRiskPointDTO.class);
        return pointDTOList;
    }
}

