package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.common.constant.StatusEnum;
import com.testor.common.util.BeanConverUtil;
import com.testor.module.contractor.enums.ConditionReviewContentEnum;
import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import com.testor.module.contractor.ledger.model.domain.TContractorPersonCertificate;
import com.testor.module.contractor.ledger.model.dto.TContractorLedgerDto;
import com.testor.module.contractor.ledger.model.dto.TContractorPersonCertificateParam;
import com.testor.module.contractor.ledger.service.TContractorLedgerService;
import com.testor.module.contractor.ledger.service.TContractorPersonCertificateService;
import com.testor.module.contractor.ledger.service.TContractorPersonService;
import com.testor.module.contractor.manage.dao.TContractorConditionReviewDetailDao;
import com.testor.module.contractor.manage.model.domain.*;
import com.testor.module.contractor.manage.model.dto.ConditionReviewContentDto;
import com.testor.module.contractor.manage.model.dto.ConditionReviewPersonCertificateDto;
import com.testor.module.contractor.manage.model.dto.TContractorAllowPersonParam;
import com.testor.module.contractor.manage.model.dto.TContractorConditionReviewDetailParam;
import com.testor.module.contractor.manage.service.*;
import com.testor.module.sys.service.NewSysDictDataService;
import com.testor.system.api.domain.SysDictData;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 承包商管理-条件审查-审查内容Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-26 10:33:15
 */
@Service
public class TContractorConditionReviewDetailServiceImpl extends SuperServiceImpl<TContractorConditionReviewDetailDao, TContractorConditionReviewDetail> implements TContractorConditionReviewDetailService
{
    @Autowired(required = false)
    private TContractorConditionReviewDetailDao tContractorConditionReviewDetailDao;

    @Autowired
    private TContractorConditionReviewService  tContractorConditionReviewService;

    @Autowired
    private TContractorLedgerService tContractorLedgerService;

    @Autowired
    private TContractorAllowPersonService tContractorAllowPersonService;

    @Autowired
    private TContractorAllowService tContractorAllowService;
    @Autowired
    private TContractorPersonService tContractorPersonService;
    @Autowired
    private TContractorPersonCertificateService tContractorPersonCertificateService;

    @Autowired
    private TContractorPreparationService tContractorPreparationService;

    @Override
    public ConditionReviewContentDto getReviewContent(TContractorConditionReviewDetailParam detail) {
        TContractorConditionReview review = tContractorConditionReviewService.getById(detail.getReviewId());
        String contractorId = review.getContractorId();
        String projId = review.getProjId();
        String bizId = review.getBizId();
        String code = detail.getCode();

        ConditionReviewContentDto contentDto = new ConditionReviewContentDto();
        if(ConditionReviewContentEnum.C01.getCode().equals(code) || ConditionReviewContentEnum.C02.getCode().equals(code)
                || ConditionReviewContentEnum.C04.getCode().equals(code) || ConditionReviewContentEnum.C07.getCode().equals(code)){
            // 审查内容为"C01-合同信息"、"C02-承包商资质"、"C04-组织架构及安全管理人员配置"、"C07-安全生产管理制度及安全生产责任制，并盖章"时，查询承包商台账信息
            // 查询承包商台账信息
            TContractorLedgerDto ledgerDto = tContractorLedgerService.getLedgerById(contractorId);
            contentDto.setContractorLedger(ledgerDto);

        } else if (ConditionReviewContentEnum.C03.getCode().equals(code) || ConditionReviewContentEnum.C05.getCode().equals(code)
                || ConditionReviewContentEnum.C11.getCode().equals(code)){
            // 审查内容为"C03-入厂人员信息"、"C05-工伤保险购买凭证；意外伤害保险或雇主责任险"、"C11-安全培训及考试"时，查询承包商准入管理人员信息
            // 1.查询准入管理数据
            TContractorAllow tContractorAllow = tContractorAllowService.getOne(new QueryWrapper<TContractorAllow>().eq(TContractorAllow.CONTRACTOR_ID
                            , contractorId).eq(TContractorAllow.PROJ_ID, projId).eq(TContractorAllow.BIZ_ID, bizId).ne(TContractorAllow.STATUS, StatusEnum.DELETE.getCode()),
                    false);
            if(tContractorAllow != null) {
                // 2.对应查询准入管理人员信息分页列表
                TContractorAllowPersonParam param = new TContractorAllowPersonParam();
                param.setAllowId(tContractorAllow.getId());
                param.setPage(detail.getPage());
                param.setLimit(detail.getLimit());
                Page<TContractorAllowPerson> resultList= tContractorAllowPersonService.listEntity(param);
                contentDto.setPersonPage(resultList);
            }

        } else if (ConditionReviewContentEnum.C06.getCode().equals(code)){
            //审查内容为"C06-特种作业人员作业证"时，查询人员证件分页列表
            // 1.查询准入管理数据
            TContractorAllow tContractorAllow = tContractorAllowService.getOne(new QueryWrapper<TContractorAllow>().eq(TContractorAllow.CONTRACTOR_ID
                            , contractorId).eq(TContractorAllow.PROJ_ID, projId).eq(TContractorAllow.BIZ_ID, bizId).ne(TContractorAllow.STATUS, StatusEnum.DELETE.getCode()),
                    false);
            if(tContractorAllow != null) {
                // 2.查询准入管理对应的人员数据
                List<String> personIdsByAllowId = this.getSpecialPersonIdsByAllowId(tContractorAllow.getId());
                TContractorPersonCertificateParam certificateParam = new TContractorPersonCertificateParam();
                certificateParam.setPage(detail.getPage());
                certificateParam.setLimit(detail.getLimit());
                Page<ConditionReviewPersonCertificateDto> resultList = getPersonCertificatePage(certificateParam, personIdsByAllowId);
                contentDto.setPersonCertificatePage(resultList);
            }
        } else if(ConditionReviewContentEnum.C08.getCode().equals(code) || ConditionReviewContentEnum.C09.getCode().equals(code)
                || ConditionReviewContentEnum.C10.getCode().equals(code)){
            // 审查内容为"C08-针对性的应急预案，并经单位审批和盖章"、"C09-施工组织设计/施工作业方案"、"C10-入厂交底"时，查询开工准备信息
            // 查询开工准备信息
            TContractorPreparation preparation =
                    tContractorPreparationService.getByCtractorIdAndProjIdAndBizId(contractorId,projId,bizId);
            contentDto.setPreparation(preparation);
        }

        return contentDto;
    }


    private Page<ConditionReviewPersonCertificateDto> getPersonCertificatePage(TContractorPersonCertificateParam param,
                                                                         List<String> personIds){
        if(ObjectHelper.isEmpty(personIds)){
            return new Page<ConditionReviewPersonCertificateDto>();
        }
        Long page=
                StringHelper.isEmpty(param.getPage())? BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TContractorPersonCertificate> resultPage=new Page<>(page,limit);
        QueryWrapper<TContractorPersonCertificate> queryWrapper=new QueryWrapper<>();
        queryWrapper.in(TContractorPersonCertificate.PERSON_ID,personIds);
        Page<TContractorPersonCertificate> resultList=tContractorPersonCertificateService.page(resultPage,queryWrapper);
        Page<ConditionReviewPersonCertificateDto> dtoPage = BeanConverUtil.conver(resultList, Page.class);
        List<ConditionReviewPersonCertificateDto> dtoList = new ArrayList<>();
        if(ObjectHelper.isNotEmpty(resultList) && ObjectHelper.isNotEmpty(resultList.getRecords())){
            for(TContractorPersonCertificate certificate: resultList.getRecords()){
                ConditionReviewPersonCertificateDto certificateDto = BeanConverUtil.conver(certificate,
                        ConditionReviewPersonCertificateDto.class);

                TContractorPerson person=tContractorPersonService.getById(certificate.getPersonId());
                certificateDto.setContractorPerson(person);
                dtoList.add(certificateDto);
            }
        }
        dtoPage.setRecords(dtoList);
        return dtoPage;
    }

    private List<String> getSpecialPersonIdsByAllowId(String allowId){
        List<TContractorAllowPerson> list = tContractorAllowPersonService.list(new LambdaQueryWrapper<>(TContractorAllowPerson.class).eq(TContractorAllowPerson::getAllowId, allowId));
        List<String> ids = new ArrayList<>();
        if (ObjectHelper.isEmpty(list)) {
            return ids;
        }
        for(TContractorAllowPerson allowPerson: list){
            String id = allowPerson.getPersonId();
            TContractorPerson person = tContractorPersonService.getById(id);
            if("特种作业人员".equals(person.getJobNature())){
                ids.add(id);
            }
        }
        return ids;
    }
}
