package com.testor.module.duty.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.duty.dao.TSysDutyMonthDao;
import com.testor.module.duty.model.domain.TSysDuty;
import com.testor.module.duty.model.domain.TSysDutyMonth;
import com.testor.module.duty.service.DutyService;
import com.testor.module.duty.service.TSysDutyMonthService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class TSysDutyMonthServiceImpl extends ServiceImpl<TSysDutyMonthDao, TSysDutyMonth> implements TSysDutyMonthService {
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private DutyService dutyService ;
    @Override
    public BaseResponse editDutyPattern(TSysDutyMonth tSysDutyMonth)throws Exception {
        String id = tSysDutyMonth.getId();
        if (ObjectHelper.isEmpty(id)) {
            throw new BusinessException("请求参数有误");
        }
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        if (Objects.isNull(sysOrg)) {
            throw new BusinessException("当前登录人部门信息不存在，请联系管理员！");
        }
        TSysDutyMonth byId = this.getById(id);
        if (byId == null) {
            throw new BusinessException("修改月不存在");
        }

        if (!tSysDutyMonth.getDutyPattern().equals(byId.getDutyPattern())) {
            QueryWrapper<TSysDuty> wrapper = new QueryWrapper<>();
            wrapper.in("ref_id", id);
            List<TSysDuty> tSysDuties = dutyService.list(wrapper);
            tSysDuties.stream().forEach(item->{
                item.setStatus("1");
                dutyService.updateById(item);
            });
        }
        BaseResponse<Object> response = new BaseResponse<>();
        byId.setUpdateDate(new Date());
        byId.setUpdateBy(loginUser.getUserId());
        byId.setDutyPattern(tSysDutyMonth.getDutyPattern());
        byId.setAllTime(tSysDutyMonth.getAllTime());
        byId.setId(id);
        byId.setMorTime(tSysDutyMonth.getMorTime());
        byId.setLateTime(tSysDutyMonth.getLateTime());
        byId.setNoonTime(tSysDutyMonth.getNoonTime());
        boolean result = this.updateById(byId);
        return response;
    }

    @Override
    public BaseResponse dutyAddMonth(TSysDutyMonth tSysDutyMonth) throws Exception{
        String id = tSysDutyMonth.getId();
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(tSysDutyMonth) && StringHelper.isNotEmpty(id)) {
            TSysDutyMonth data = BeanHelper.beanToBean(tSysDutyMonth, TSysDutyMonth.class);
            TSysDutyMonth month = this.getById(data.getId());
            month.setId(data.getId());
            month.setProcessStatus(data.getProcessStatus());
            month.setProcessId(data.getProcessId());
            month.setRejectOpinion(data.getRejectOpinion());
            boolean result = this.updateById(month);
            QueryWrapper<TSysDuty> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("ref_id",id);
            List<TSysDuty> tSysDuties = dutyService.list(queryWrapper);
            for (TSysDuty tSysDuty : tSysDuties) {
                tSysDuty.setProcessStatus(data.getProcessStatus());
                result = dutyService.updateById(tSysDuty);
            }
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @Override
    public BaseResponse getCreateDutyMon() {
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        //当前年月
        String format = simpleDateFormat.format(new Date());
        QueryWrapper<TSysDutyMonth> wrapper = new QueryWrapper<>();
        wrapper.ge("duty_date", format)
                .eq("company_id", loginUser.getOrgId());
        wrapper.select("duty_date");
        List<TSysDutyMonth> list = this.list(wrapper);
        List<TSysDutyMonth> collect = list.stream().sorted(Comparator.comparing(TSysDutyMonth::getDutyDate)).collect(Collectors.toList());
        BaseResponse<List<TSysDutyMonth>> response = new BaseResponse<>();
        response.setData(collect);
        return response;
    }

}
