package com.testor.module.fives.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.fives.model.domain.TFivesSubOption;
import com.testor.module.fives.model.dto.TFivesSubOptionParam;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 5s内容分项Mapper接口
 *
 * @author testor-framework
 * @date 2022-07-11 14:07:47
 */
public interface TFivesSubOptionDao extends SuperDao<TFivesSubOption> {

    /**
     * 查看分页列表
     *
     * @param page  分页参数
     * @param query 查询参数
     * @return
     */
    IPage<TFivesSubOption> standardCheck(Page<TFivesSubOption> page, @Param("query") TFivesSubOptionParam query);

    /**
     * 查看页面 检索框-主要内容下拉使用
     *
     * @param id 5s标准id
     * @return 内容列表
     */
    List<String> getMainContent(@Param("id") String id);

    /**
     * 计算满分
     *
     * @param query 查询参数
     * @return
     */
    String standardCheckSum(@Param("query") TFivesSubOptionParam query);

}
