package com.testor.module.hazard.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.TContractorAccessLogApproval;
import com.testor.module.hazard.model.domain.THazardWorkPlanMonitoringRecord;
import com.testor.module.hazard.model.dto.TContractorAccessLogApprovalParam;
import com.testor.module.hazard.model.dto.THazardWorkPlanMonitoringRecordParam;
import com.testor.module.hazard.service.THazardWorkPlanMonitoringRecordService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/hazard/hazardWorkPlanMonitoringRecord")
@Api(value = "THazardWorkPlanMonitoringRecordController", tags = "危险作业计划监控记录")
@Slf4j
public class THazardWorkPlanMonitoringRecordController {

    @Autowired
    private THazardWorkPlanMonitoringRecordService tHazardWorkPlanMonitoringRecordService;

    @ApiOperation(value = "获取 危险作业计划监控记录 分页列表", notes = "List THazardWorkPlanMonitoringRecord with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<THazardWorkPlanMonitoringRecord>> listEntity(THazardWorkPlanMonitoringRecordParam param){
        BaseResponse<BaseResponseList<THazardWorkPlanMonitoringRecord>>baseResponse=new BaseResponse<>();
        Page<THazardWorkPlanMonitoringRecord> THazardWorkPlanMonitoringRecord = tHazardWorkPlanMonitoringRecordService.selectPage(param);
        BaseResponseList<THazardWorkPlanMonitoringRecord> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(THazardWorkPlanMonitoringRecord.getRecords());
        baseResponseList.setTotal(THazardWorkPlanMonitoringRecord.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }


    @ApiOperation(value = "新增 危险作业计划监控记录", notes = "Add THazardWorkPlanMonitoringRecord")
    @PostMapping(value = "/add")
    public BaseResponse<THazardWorkPlanMonitoringRecord> addEntity(@RequestBody THazardWorkPlanMonitoringRecord addRequest) {
        BaseResponse<THazardWorkPlanMonitoringRecord> baseResponse=new BaseResponse<>();
        if(ObjectHelper.isNotEmpty(addRequest)){
            tHazardWorkPlanMonitoringRecordService.insertContractorAccessLogApproval(addRequest);
        }
        return baseResponse;
    }

}
