package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 危险作业许可证-签字记录对象 t_hazard_license_signature_record
 * 
 * @author testor-framework
 * @date 2024-12-26 10:53:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_license_signature_record")
@ApiModel(value = "THazardLicenseSignatureRecord对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardLicenseSignatureRecord extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 计划id
 */
  @ApiModelProperty(value = "计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 许可证id
 */
  @ApiModelProperty(value = "许可证id")

  @TableField("license_id")
  private String licenseId;
/**
 * 1=作业所在部门,2=作业主管部门,3=安全管理部门,4=主管部门负责人,5=公司级分管领导负责人,6=公司级安环部,7=安全分管领导或主要负责人
 */
  @ApiModelProperty(value = "1=作业所在部门,2=作业主管部门,3=安全管理部门,4=主管部门负责人,5=公司级分管领导负责人,6=公司级安环部,7=安全分管领导或主要负责人")

  @TableField("type")
  private String type;

  /**
   * 签字节点名称
   */
  @ApiModelProperty(value = "签字节点名称")
  @TableField("type_name")
  private String typeName;
/**
 * 签字人
 */
  @ApiModelProperty(value = "签字人")

  @TableField("signatory")
  private String signatory;

  /**
   * 签字人
   */
  @ApiModelProperty(value = "签字人名称")

  @TableField(exist = false)
  @Translation(type = TransConstant.USER_ID_TO_NAME,mapper = "signatory")
  private String signatoryName;
/**
 * 签字
 */
  @ApiModelProperty(value = "签字")

  @TableField("signature")
  private String signature;
/**
 * 签字地点
 */
  @ApiModelProperty(value = "签字地点")

  @TableField("signature_location")
  private String signatureLocation;
/**
 * 签字时间
 */
  @ApiModelProperty(value = "签字时间")

  @TableField("signature_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signatureDate;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String LICENSE_ID ="license_id";
  public static final String TYPE ="type";
  public static final String SIGNATORY ="signatory";
  public static final String SIGNATURE ="signature";
  public static final String SIGNATURE_LOCATION ="signature_location";
  public static final String SIGNATURE_DATE ="signature_date";
  public static final String TYPE_NAME ="type_name";

}
