package com.testor.module.partner.service.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.file.FileEnumCode;
import com.testor.biz.file.model.domain.TSysFileBiz;
import com.testor.biz.file.service.TSysFileBizService;
import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.role.model.domain.SysRole;
import com.testor.biz.sys.role.service.SysRoleService;
import com.testor.biz.sys.user.UserEnumCode;
import com.testor.biz.sys.user.UserHelper;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.model.dto.SysUserCreateAndUpdateRequest;
import com.testor.biz.sys.user.model.dto.SysUserRoleRequest;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.biz.sys.userRole.model.domain.SysUserRole;
import com.testor.biz.sys.userRole.service.SysUserRoleService;
import com.testor.common.constant.StatusEnum;
import com.testor.common.util.excel.LocalDateTimeConverter;
import com.testor.module.duty.util.PoiExcelUtils;
import com.testor.module.partner.dao.TPartnerStaffDao;
import com.testor.module.partner.model.domain.TPartnerCertificate;
import com.testor.module.partner.model.domain.TPartnerOrg;
import com.testor.module.partner.model.domain.TPartnerStaff;
import com.testor.module.partner.model.dto.TPartnerCertificateDTO;
import com.testor.module.partner.model.dto.TPartnerStaffDTO;
import com.testor.module.partner.model.dto.TPartnerStaffParam;
import com.testor.module.partner.model.excel.PartnerStaffImport;
import com.testor.module.partner.model.excel.PartnerStaffReport;
import com.testor.module.partner.model.vo.OrganizationPersonnelVO;
import com.testor.module.partner.model.vo.PartnerStaffDetailVO;
import com.testor.module.partner.service.TPartnerCertificateService;
import com.testor.module.partner.service.TPartnerOrgService;
import com.testor.module.partner.service.TPartnerStaffService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 相关方机构员工Service业务层处理
 *
 * @author testor-framework
 * @date 2022-06-01 14:18:06
 */
@Component("tPartnerStaffService")
public class TPartnerStaffServiceImpl extends SuperServiceImpl<TPartnerStaffDao, TPartnerStaff> implements TPartnerStaffService {

    private static final Logger logger = LoggerFactory.getLogger(TPartnerStaffServiceImpl.class);

    @Autowired(required = false)
    private TPartnerStaffDao tPartnerStaffDao;

    @Resource
    private TPartnerCertificateService certificateService;

    @Autowired(required = false)
    @Lazy
    private TPartnerOrgService partnerOrgService;

    @Autowired
    private SysOrgService sysOrgService;

    @Autowired
    private SysUserService sysUserService;

    @Autowired
    private SysUserRoleService sysUserRoleService;

    @Autowired
    private TSysFileBizService tSysFileBizService;

    @Autowired
    private TPartnerCertificateService tPartnerCertificateService;

    @Autowired
    private SysRoleService sysRoleService;

    @Value("${ureport.path}")
    private String path;

    @Override
    public Map<String, List<OrganizationPersonnelVO>> getOrganizationPersonnel() {
        String orgId = ContextUtils.getLoginUser().getOrgId();
        List<OrganizationPersonnelVO> list = tPartnerStaffDao.getOrganizationPersonnel(orgId);
        return list.stream().collect(Collectors.groupingBy(OrganizationPersonnelVO::getOrgName));
    }


    @Transactional(rollbackFor = Exception.class)
    public SysUser addEntity(SysUserCreateAndUpdateRequest addRequest, String currentUserId, String deptId) throws ApiException {
        if (ObjectHelper.isEmpty(addRequest)) {
            throw new ApiException(UserEnumCode.USER_PARAM_IS_NULL.transform());
        } else if (StringHelper.isEmpty(addRequest.getLoginPwd())) {
            throw new ApiException(UserEnumCode.REQUIRED_ITEMS_MISSING.transform());
        } else if (!StringHelper.isEmpty(addRequest.getOrgId()) && !ObjectHelper.isEmpty(sysOrgService.getById(addRequest.getOrgId()))) {
            SysUser existsSysUser = sysUserService.getOne((Wrapper) ((QueryWrapper) ((QueryWrapper) (new QueryWrapper()).eq("login_name", addRequest.getLoginName())).ne("status", "1")).last("LIMIT 1"));
            if (ObjectHelper.isNotEmpty(existsSysUser)) {
                throw new ApiException(UserEnumCode.LOGIN_NAME_ALREADY_EXISTS.transform());
            } else {
                String userId = IdHelper.getId32bit();
                if (ObjectHelper.isNotEmpty(addRequest.getFiles()) && !addRequest.getFiles().isEmpty()) {
                    List<TSysFileBiz> fileBizList = addRequest.getFiles();
                    boolean fileBizResult = tSysFileBizService.saveFileBizs(fileBizList, userId, currentUserId);
                    if (!fileBizList.isEmpty() && !fileBizResult) {
                        throw new ApiException(FileEnumCode.FILE_BIZ_SAVE_FAILED.transform());
                    }
                }

                SysUser data = BeanHelper.beanToBean(addRequest, SysUser.class);
                if (StringHelper.isEmpty(data.getLoginPwd())) {
                    data.setLoginPwd("123456");
                }

                data.setLoginPwd(UserHelper.userPassword(data.getLoginPwd()));
                data.setUserId(userId);
                data.setOrgId(addRequest.getOrgId());
                data.setDeptId(deptId);
                this.sysUserService.save(data);
                return data;
            }
        } else {
            throw new ApiException(UserEnumCode.USER_ORG_ID_ERROR.transform());
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean assignEntity(SysUserRoleRequest assignRequest) {
        this.sysUserRoleService.remove((Wrapper) (new QueryWrapper()).eq("user_id", assignRequest.getUserId()));
        if (ObjectHelper.isNotEmpty(assignRequest.getRoleId())) {
            ArrayList<SysUserRole> userRoles = new ArrayList(16);
            String[] var4 = assignRequest.getRoleId();
            int var5 = var4.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                String roleId = var4[var6];
                userRoles.add((new SysUserRole()).setUserId(assignRequest.getUserId()).setRoleId(roleId));
            }
            return this.sysUserRoleService.saveBatch(userRoles);
        }

        return false;
    }

    /**
     * 根据用户id获取角色信息
     *
     * @param userId 用户id
     * @return
     */
    public List<Map<String, Object>> showEntities(String userId) {
        BaseResponse<List<Map<String, Object>>> baseResponse = new BaseResponse();
        if (StringHelper.isEmpty(userId)) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        } else {
            List<SysRole> roles = this.sysRoleService.list((new QueryWrapper()).ne(true, "status", "1"));
            List<SysUserRole> checkedRoles = this.sysUserRoleService.list((Wrapper) (new QueryWrapper()).eq("user_id", userId));
            List<String> checkedRoleIds = (List) checkedRoles.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
            List<Map<String, Object>> data = BeanHelper.beansToMaps(roles);
            Iterator var7 = data.iterator();

            while (var7.hasNext()) {
                Map<String, Object> role = (Map) var7.next();
                if (checkedRoleIds.contains(String.valueOf(role.get("roleId")))) {
                    role.put("isChecked", true);
                } else {
                    role.put("isChecked", false);
                }
            }

            return data;
        }
    }

    /**
     * 添加用户
     *
     * @param curUser   当前登录用户信息
     * @param loginName 所设定的登录用户账号
     * @param roleIds   角色表主键数组
     * @return 登录用户id
     * @throws RuntimeException
     */
    @Transactional(rollbackFor = Exception.class)
    public String addUser(UserInfo curUser, String loginName, String[] roleIds, TPartnerStaffDTO tPartnerStaffDTO) throws ApiException {

        SysUserCreateAndUpdateRequest request = new SysUserCreateAndUpdateRequest();
        request.setOrgId(curUser.getOrgId());
        request.setLoginPwd("123456");
        request.setLoginName(loginName);
        request.setPhoneNo(tPartnerStaffDTO.getPhone());
        request.setUserName(tPartnerStaffDTO.getName());
        request.setSex(tPartnerStaffDTO.getSex());
        List<SysOrg> list = sysOrgService.list(new LambdaQueryWrapper<SysOrg>().eq(SysOrg::getParentId, curUser.getOrgId()));
        String deptId = null;
        if (ObjectUtil.isNotEmpty(list)) {
            Map<String, List<SysOrg>> collect = list.stream().collect(Collectors.groupingBy(SysOrg::getOrgName));
            List<SysOrg> sysOrgs = collect.get("相关方部门");
            if (ObjectUtil.isEmpty(sysOrgs)) {
                //创建部门
                SysOrg sysOrg = new SysOrg();
                sysOrg.setOrgName("相关方部门");
                sysOrg.setIsDept("1");
                sysOrg.setParentId(curUser.getOrgId());
                sysOrgService.save(sysOrg);
                deptId = sysOrg.getOrgId();
            } else {
                SysOrg sysOrg = sysOrgs.get(0);
                deptId = sysOrg.getOrgId();
            }
        }


        SysUser user;
        try {
            user = addEntity(request, curUser.getUserId(), deptId);
        } catch (ApiException e) {
            throw e;
        }
        if (ObjectUtils.isEmpty(user)) {
            throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "用户添加失败"));
        }
        String userId = user.getUserId();
        SysUserRoleRequest assignRequest = new SysUserRoleRequest();
        assignRequest.setRoleId(roleIds);
        assignRequest.setUserId(userId);
        boolean assignEntity = assignEntity(assignRequest);
        if (assignEntity) {
            return userId;
        }
        return null;
    }

    /**
     * 编辑相关方人员
     *
     * @param partnerStaff
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse<TPartnerStaff> editPartnerStaff(TPartnerStaffDTO partnerStaff) {

        BaseResponse<TPartnerStaff> baseResponse = new BaseResponse<>();

        boolean checkIdCard = IdcardUtil.isValidCard(partnerStaff.getIdcard());
        if (!checkIdCard) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("身份证格式不正确");
            return baseResponse;
        }

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        String curUserOrgId = curUser.getOrgId();


        boolean checkResult = checkPartnerStaff(partnerStaff.getId(), partnerStaff.getIdcard(), partnerStaff.getPartnerId());
        if (!checkResult) {
            baseResponse.setCode(BaseStatusEnum.UNKNOWN.code());
            baseResponse.setMsg("已存在相同的身份证信息的员工");
            return baseResponse;
        }

        TPartnerStaff data = BeanHelper.beanToBean(partnerStaff, TPartnerStaff.class);
        List<TPartnerCertificateDTO> certificateIdList = partnerStaff.getCertificateIdList();
        String dataId = data.getId();

        data.setCertificateStatus(1);

        if (StrUtil.isBlank(dataId)) {
            // 新增
            String loginName = partnerStaff.getLoginName();
            if (!StrUtil.isBlank(loginName)) {
                try {
                    String addUserId = addUser(curUser, loginName, partnerStaff.getRoleIds(), partnerStaff);
                    if (StrUtil.isEmpty(addUserId)) {
                        throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "用户id为空，添加失败"));
                    }
                    data.setSysUserId(addUserId);
                } catch (ApiException e) {
                    throw e;
                }
            }
            String name = partnerStaff.getName();
            if (!StrUtil.isBlank(name)) {
                data.setCreateBy(curUser.getUserId());
                data.setOrgId(curUserOrgId);
                tPartnerStaffDao.insert(data);
            }
            int certificateCount = 0;
            // 新增资质信息
            for (TPartnerCertificateDTO tPartnerCertificateDTO : certificateIdList) {
                String bizId = tPartnerCertificateDTO.getBizId();
                if (StrUtil.isBlank(bizId)) {
                    tPartnerCertificateDTO.setBizId(data.getId());
                }
                tPartnerCertificateDTO.setUseType(2);
                tPartnerCertificateDTO.setRemarks(tPartnerCertificateDTO.getRemarks());
                TPartnerCertificate tPartnerCertificate = tPartnerCertificateService.editCertificate(tPartnerCertificateDTO);
                if (!ObjectUtils.isEmpty(tPartnerCertificate)) {
                    certificateCount++;
                }
            }
            if (certificateCount != certificateIdList.size()) {
                throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "创建失败"));
            }
            baseResponse.setData(data);

            return baseResponse;
        } else {
            // 修改
            if (!curUserOrgId.equals(partnerStaff.getOrgId())) {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("当前用户无法操作该条数据");
                return baseResponse;
            }
            String loginName = partnerStaff.getLoginName();
            if (!StrUtil.isBlank(loginName)) {
                try {
                    SysUser sysUser = sysUserService.getOne(new QueryWrapper<SysUser>().eq("login_name", loginName));
                    if (sysUser == null) {
                        String addUserId = addUser(curUser, loginName, partnerStaff.getRoleIds(), partnerStaff);
                        if (StrUtil.isEmpty(addUserId)) {
                            throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), "用户id为空，添加失败"));
                        }
                        data.setSysUserId(addUserId);
                    }
                } catch (ApiException e) {
                    throw e;
                }
            }
            data.setUpdateBy(curUser.getUserId());
            tPartnerStaffDao.updateById(data);

            List<TPartnerCertificate> tPartnerCertificates = BeanHelper.listToList(certificateIdList, TPartnerCertificate.class);
            tPartnerCertificates.forEach(item -> {
                item.setBizId(data.getId());
                boolean check = tPartnerCertificateService.checkValidity(item.getValidEndDate());
                String state = "1";
                if (check) {
                    state = "0";
                }
                item.setState(state);
            });

            Map<Boolean, List<TPartnerCertificate>> collect = tPartnerCertificates.stream().collect(Collectors.partitioningBy(x -> ObjectUtil.isEmpty(x.getId())));
            List<TPartnerCertificate> tPartnerCertificates1 = collect.get(true);
            List<TPartnerCertificate> tPartnerCertificates2 = collect.get(false);
            tPartnerCertificates2.forEach(tPartnerCertificate -> {
                tPartnerCertificate.setState("1");
            });
            //修改用户信息
            String sysUserId = partnerStaff.getSysUserId();
            SysUser sysUser = new SysUser();
            sysUser.setUserId(sysUserId);
            sysUser.setUserName(partnerStaff.getName());
            sysUser.setSex(partnerStaff.getSex());
            sysUser.setPhoneNo(partnerStaff.getPhone());
            if (partnerStaff.getSex().equals("0")) {
                partnerStaff.setSex("1");
            } else {
                partnerStaff.setSex("0");
            }
            sysUser.setSex(partnerStaff.getSex());
            sysUserService.updateById(sysUser);
            //修改用户角色信息
            sysUserRoleService.remove(new QueryWrapper<SysUserRole>().eq("user_id", sysUserId));
            //目前相关方角色只能单选
            String[] roleIds = partnerStaff.getRoleIds();
            for (String roleId : roleIds) {
                if (StringUtils.isNotBlank(roleId)) {
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(sysUserId);
                    sysUserRole.setRoleId(roleId);
                    sysUserRoleService.save(sysUserRole);
                }
            }
            //是否删除资质
            if (partnerStaff.getDelIds().size() > 0) {
                for (String delId : partnerStaff.getDelIds()) {
                    TPartnerCertificate tPartnerCertificate = new TPartnerCertificate();
                    tPartnerCertificate.setId(delId);
                    tPartnerCertificate.setStatus(BizConstants.STATUS_DELETE);
                    boolean result = tPartnerCertificateService.updateById(tPartnerCertificate);
                }
            }

            tPartnerCertificateService.saveBatch(tPartnerCertificates1);
            tPartnerCertificateService.updateBatchById(tPartnerCertificates2);

            baseResponse.setData(data);
            return baseResponse;
        }


    }


    /**
     * 检测该员工在相关方机构下是否已经存在
     *
     * @param idcard
     * @param partnerOrgId
     * @return false-检测不通过   true-检测通过
     */
    public Boolean checkPartnerStaff(String partnerStaffId, String idcard, String partnerOrgId) {
        if (StrUtil.isBlank(idcard) || StrUtil.isBlank(partnerOrgId)) {
            return false;
        }

        LambdaQueryWrapper<TPartnerStaff> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TPartnerStaff::getIdcard, idcard)
                .eq(TPartnerStaff::getPartnerId, partnerOrgId)
                .eq(TPartnerStaff::getStatus, StatusEnum.USE.getCode());
        if (!StrUtil.isBlank(partnerStaffId)) {
            queryWrapper.ne(TPartnerStaff::getId, partnerStaffId);
        }
        List<TPartnerStaff> partnerOrgList = tPartnerStaffDao.selectList(queryWrapper);
        if (partnerOrgList != null && partnerOrgList.size() > 0) {
            return false;
        }

        return true;
    }

    /**
     * 获取 导出相关方人员的 数据源
     */
    @SneakyThrows
    @Override
    public List<PartnerStaffReport> exportPartnerStaff(HttpServletResponse response, TPartnerStaffParam param) {
        UserInfo loginUser = ContextUtils.getLoginUser();
        String orgId = null;
        if (loginUser != null) {
            orgId = loginUser.getOrgId();
        }
        List<PartnerStaffReport> partnerExpList = tPartnerStaffDao.findPartnerStaffExportData(orgId, param);
        response.setContentType("application/vnd.ms-excel");
        // 对响应进行重新编码
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("相关方人员列表", "utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        response.addHeader("Pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
        InputStream templatePathName = this.getClass().getClassLoader().getResourceAsStream("excel/xgfry.xlsx");
        ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).withTemplate(templatePathName).registerConverter(new LocalDateTimeConverter()).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
        // 直接写入数据
        excelWriter.fill(partnerExpList, fillConfig, writeSheet);
        // 写入list之前的数据
        excelWriter.finish();
        return partnerExpList;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public BaseResponse<String> addReportByExcel(MultipartFile file) {

        BaseResponse<String> baseResponse = new BaseResponse<>();
        StringBuilder sbMsg = new StringBuilder();

        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = PoiExcelUtils.readFile(inputStream, Objects.requireNonNull(file.getOriginalFilename()));
            Sheet sheet = workbook.getSheetAt(0);    //获得第一个表单

            System.out.println("总行数:" + sheet.getLastRowNum());

            List<CellRangeAddress> cras = PoiExcelUtils.getCombineCell(sheet);
            int count = sheet.getLastRowNum() + 1;//总行数


            Map<String, String> idCardMap = new HashMap<>();
            Map<String, TPartnerOrg> partnerOrgMap = new HashMap<>();
            SimpleDateFormat timeDtf = new SimpleDateFormat("yyyy-MM-dd");

            List<TPartnerStaffDTO> irs = new ArrayList<>();
            for (int i = 2; i < count; i++) {
                Row row = sheet.getRow(i);

                TPartnerStaffDTO partnerStaffDTO = new TPartnerStaffDTO();

                partnerStaffDTO.setSerialNumber(Integer.valueOf(PoiExcelUtils.getCellValue(row.getCell(0))));
                partnerStaffDTO.setPartnerName(PoiExcelUtils.getCellValue(row.getCell(3)));
                partnerStaffDTO.setName(PoiExcelUtils.getCellValue(row.getCell(5)));
                partnerStaffDTO.setIdcard(PoiExcelUtils.getCellValue(row.getCell(6)));
                partnerStaffDTO.setPhone(PoiExcelUtils.getCellValue(row.getCell(7)));
                partnerStaffDTO.setWorkType(PoiExcelUtils.getCellValue(row.getCell(8)));

                List<TPartnerCertificateDTO> items = new ArrayList<>();
                if (PoiExcelUtils.isMergedRegion(sheet, i, 0)) {
                    int lastRow = PoiExcelUtils.getRowNum(cras, sheet.getRow(i).getCell(0), sheet);

                    for (; i <= lastRow; i++) {
                        row = sheet.getRow(i);
                        TPartnerCertificateDTO item = new TPartnerCertificateDTO();
                        item.setName(PoiExcelUtils.getCellValue(row.getCell(9)));
                        item.setCode(PoiExcelUtils.getCellValue(row.getCell(10)));
                        Date parse = timeDtf.parse(PoiExcelUtils.getCellValue(row.getCell(11)));
                        item.setValidEndDate(parse);
                        items.add(item);
                    }
                    i--;
                } else {
                    row = sheet.getRow(i);
                    TPartnerCertificateDTO item = new TPartnerCertificateDTO();
                    item.setName(PoiExcelUtils.getCellValue(row.getCell(9)));
                    item.setCode(PoiExcelUtils.getCellValue(row.getCell(10)));
                    Date parse = timeDtf.parse(PoiExcelUtils.getCellValue(row.getCell(11)));
                    item.setValidEndDate(parse);
                    items.add(item);
                }
                partnerStaffDTO.setCertificateIdList(items);
                irs.add(partnerStaffDTO);

            }
            int success = 0;
            for (TPartnerStaffDTO inspectionReport : irs) {

                int serialNumber = inspectionReport.getSerialNumber();


                String partnerName = inspectionReport.getPartnerName();
                TPartnerOrg partnerOrg;
                if (ObjectUtils.isEmpty(partnerOrgMap.get(partnerName))) {
                    LambdaQueryWrapper<TPartnerOrg> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(TPartnerOrg::getStatus, StatusEnum.USE.getCode())
                            .eq(TPartnerOrg::getName, partnerName);
                    List<TPartnerOrg> partnerOrgList = partnerOrgService.list(queryWrapper);
                    if (partnerOrgList == null || partnerOrgList.size() == 0) {
                        sbMsg.append("第 [").append(serialNumber).append("] 用户的所属单位 [").append(partnerName).append("] 不存在 & ");
                        continue;
                    }
                    partnerOrg = partnerOrgList.get(0);
                    partnerOrgMap.put(partnerName, partnerOrg);
                } else {
                    partnerOrg = partnerOrgMap.get(partnerName);
                }

                String partnerOrgId = partnerOrg.getId();
                inspectionReport.setPartnerId(partnerOrgId);

                String idCard = inspectionReport.getIdcard();

                boolean checkIdCard = IdcardUtil.isValidCard(idCard);
                if (!checkIdCard) {
                    sbMsg.append("第 [").append(serialNumber).append("] 身份证格式不正确：").append(idCard).append(" & ");
                    continue;
                }

                if (!StrUtil.isEmpty(idCardMap.get(idCard))) {
                    sbMsg.append("第 [").append(serialNumber).append("] 存在相同身份证号：").append(idCard).append(" & ");
                    continue;
                } else {
                    idCardMap.put(idCard, idCard);
                }

                boolean checkResult = checkPartnerStaff(null, idCard, partnerOrgId);
                if (!checkResult) {
                    sbMsg.append("第 [").append(serialNumber).append("] 身份证 [").append(idCard).append("] 的用户已存在未导入  & ");
                    continue;
                }

                BaseResponse<TPartnerStaff> tPartnerStaffBaseResponse = editPartnerStaff(inspectionReport);
                if (tPartnerStaffBaseResponse.getCode() == BaseStatusEnum.SUCCESS.code()) {
                    success++;
                }
            }

            sbMsg.append("成功导入 [").append(success).append("] 条");

        } catch (Exception ex) {
            ex.printStackTrace();
            // error
            throw new ApiException(new ResponseInfo(BaseStatusEnum.UN_DATA.code(), ex.getMessage()));
        }

        baseResponse.setMsg(sbMsg.toString());
        return baseResponse;
    }



    /*@Transactional
    public BaseResponse<String> importPartnerStaff(MultipartFile file) {
        BaseResponse<String> baseResponse = new BaseResponse<>();
        StringBuilder sbMsg = new StringBuilder();

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        String curUserOrgId = curUser.getOrgId();

        //判断是否为null
        if (file.equals("") || file.getSize() <= 0) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("上传文件数据错误");
            return baseResponse;
        }

        try {
            InputStream inputStream = file.getInputStream();
            // 读取Excel⽂件⼯作表
            Workbook workbook = PoiExcelUtils.readFile(inputStream, Objects.requireNonNull(file.getOriginalFilename()));
            //取得第⼀个⼯作表
            Sheet sheet = workbook.getSheetAt(0);
            //报表上传的每条数据
            List<Map<Integer, Object>> dataList = PoiExcelUtils.getBody(sheet, 13, 2);
            if (dataList.size() == 0) {
                baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                baseResponse.setMsg("用户信息错误");
                return baseResponse;
            }

            PartnerStaffExp partnerExp;
            List<PartnerStaffExp> partnerExpList = new ArrayList<>();
            DateTimeFormatter timeDtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");

            Map<String, String> idcardMap = new HashMap<>();
            Map<String, TPartnerOrg> partnerOrgMap = new HashMap<>();

            for (Map<Integer, Object> rowData : dataList) {
                System.err.println(JSON.toJSONString(rowData));

                if (rowData.get(3) == null || StrUtil.isBlank(rowData.get(4).toString())
                        || rowData.get(5) == null) {
                    continue;
                }

                String idcard = rowData.get(6).toString().trim();
                boolean checkIdCard = IdcardUtil.isValidCard(idcard);
                if (!checkIdCard) {
                    baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                    baseResponse.setMsg("身份证格式不正确：" + idcard);
                    return baseResponse;
                }

                // 检测所属单位（相关方机构）是否存在
                String partnerName = rowData.get(3).toString().trim();
                TPartnerOrg partnerOrg;
                if (partnerOrgMap.get(partnerName) == null) {
                    LambdaQueryWrapper<TPartnerOrg> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(TPartnerOrg::getStatus, "0")
                            .eq(TPartnerOrg::getName, partnerName);
                    List<TPartnerOrg> partnerOrgList = partnerOrgService.list(queryWrapper);
                    if (partnerOrgList == null || partnerOrgList.size() == 0) {
                        sbMsg.append("身份证号[" + rowData.get(2).toString().trim() + "]用户的所属单位[" + partnerName + "]不存在;");
                        continue;
                    }
                    partnerOrg = partnerOrgList.get(0);
                    partnerOrgMap.put(partnerName, partnerOrg);
                } else {
                    partnerOrg = partnerOrgMap.get(partnerName);
                }

            }

            *//*






                String mapKey = idcard + rowData.get(7).toString().trim();
                if (idcardMap.get(mapKey) != null) {
                    baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
                    baseResponse.setMsg("存在相同的身份证号：" + idcard);
                    return baseResponse;
                }



                boolean checkResult = checkPartnerStaff(null, idcard, partnerOrg.getId());
                if (!checkResult) {
                    sbMsg.append("身份证[" + idcard + "]的用户已存在未导入;");
                    continue;
                }

                idcardMap.put(mapKey, rowData.get(0).toString());
                partnerExp = new PartnerStaffExp();
                partnerExp.setName(rowData.get(1).toString());
                partnerExp.setSex("女".equals(rowData.get(2).toString()) ? "0" : "1");
                partnerExp.setIdcard(idcard);
                partnerExp.setPhone(rowData.get(4).toString());
                partnerExp.setPartnerName(rowData.get(5).toString());
                partnerExp.setWorkType(rowData.get(6).toString());
                partnerExp.setCertificateName(rowData.get(7).toString());
                if (rowData.get(8) != null) {
                    partnerExp.setCertificateCode(rowData.get(8).toString());
                }
                partnerExp.setCertificateValidEndDate(LocalDateTime.parse(rowData.get(9).toString(), timeDtf));
                if (rowData.get(10) != null) {
                    partnerExp.setCertificateRemarks(rowData.get(10).toString());
                }

                partnerExp.setPartnerId(partnerOrg.getId());
                partnerExpList.add(partnerExp);
            *//*

//            System.out.println(partnerExpList);

            // 保存处理
//            handleExcelData(partnerExpList);
        } catch (Exception e) {
            e.printStackTrace();
        }
        baseResponse.setData(sbMsg == null ? "导入成功" : sbMsg.toString());
        return baseResponse;
    }*/

    /*@Async
    @Transactional
    public void handleExcelData(List<PartnerStaffExp> partnerExpList) {
        if (partnerExpList == null || partnerExpList.size() == 0) {
            return;
        }

        UserInfo curUser = ContextUtils.getLoginUser();

        List<TPartnerStaff> tPartnerStaffList = new ArrayList<>();
        TPartnerStaff tPartnerStaff;
        List<TPartnerCertificate> tPartnerCertificateList = new ArrayList<>();
        TPartnerCertificate tPartnerCertificate;
        Map<String, List<TPartnerCertificate>> partnerCertificateMap = new HashMap<>();
        for (PartnerStaffExp partnerExp : partnerExpList) {

            // 创建相关方机构证书
            tPartnerCertificate = new TPartnerCertificate();
            tPartnerCertificate.setName(partnerExp.getCertificateName());
            if (!StrUtil.isBlank(partnerExp.getCertificateCode())) {
                tPartnerCertificate.setCode(partnerExp.getCertificateCode());
            }
            if (!StrUtil.isBlank(partnerExp.getCertificateRemarks())) {
                tPartnerCertificate.setRemarks(partnerExp.getCertificateRemarks());
            }
            tPartnerCertificate.setType("2");
            tPartnerCertificate.setValidEndDate(partnerExp.getCertificateValidEndDate());
            boolean certificateCheckResult = certificateService.checkValidity(partnerExp.getCertificateValidEndDate());
            tPartnerCertificate.setState(certificateCheckResult ? "0" : "1");

            tPartnerCertificate.setCreateBy(curUser.getUserId());
            tPartnerCertificateList.add(tPartnerCertificate);

            String idcard = partnerExp.getIdcard();
            // 此 身份证号已存在，不进行创建相关方人员
            if (partnerCertificateMap.get(partnerExp.getIdcard()) != null) {
                List<TPartnerCertificate> tPartnerCertificateMapList = partnerCertificateMap.get(idcard);
                tPartnerCertificateMapList.add(tPartnerCertificate);
                partnerCertificateMap.put(idcard, tPartnerCertificateMapList);
                continue;
            }

            List<TPartnerCertificate> tPartnerCertificateMapList = new ArrayList<>();
            tPartnerCertificateMapList.add(tPartnerCertificate);
            partnerCertificateMap.put(idcard, tPartnerCertificateMapList);

            // 创建相关方人员
            tPartnerStaff = new TPartnerStaff();
            tPartnerStaff.setPartnerId(partnerExp.getPartnerId());
            tPartnerStaff.setName(partnerExp.getName());
            tPartnerStaff.setSex(Integer.parseInt(partnerExp.getSex().toString()));
            tPartnerStaff.setWorkType(partnerExp.getWorkType());
            tPartnerStaff.setIdcard(partnerExp.getIdcard());
            tPartnerStaff.setPhone(partnerExp.getPhone());

            tPartnerStaff.setOrgId(curUser.getOrgId());
            tPartnerStaff.setCreateBy(curUser.getUserId());
            tPartnerStaffList.add(tPartnerStaff);
        }

        if (tPartnerCertificateList != null && tPartnerCertificateList.size() > 0) {
            certificateService.saveBatch(tPartnerCertificateList);
        }

        if (tPartnerStaffList == null || tPartnerStaffList.size() == 0) {
            return;
        }

        // 保存相关方机构
        for (TPartnerStaff partnerStaff : tPartnerStaffList) {
            List<TPartnerCertificate> partnerCertificateList = partnerCertificateMap.get(partnerStaff.getIdcard());
            List<String> certificateIdList = new ArrayList<>();
            if (partnerCertificateList != null && partnerCertificateList.size() > 0) {
                for (TPartnerCertificate certificate : partnerCertificateList) {
                    certificateIdList.add(certificate.getId());
                }
                boolean certificateStatue = certificateService.checkCertificateValidity(null, certificateIdList);
                partnerStaff.setCertificateStatus(certificateStatue ? 1 : 0);
            }

            save(partnerStaff);
            boolean certificateResult = certificateService.bindBizId(partnerStaff.getId(), certificateIdList);
        }
    }*/
    @Override
    public IPage<PartnerStaffDetailVO> listByPage(TPartnerStaffParam param) {
        Long page = StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<PartnerStaffDetailVO> resultPage = new Page<>(page, limit);
        String status = param.getStatus();
        if (StrUtil.isEmpty(status)) {
            param.setStatus(StatusEnum.USE.getCode());
        }

        IPage<PartnerStaffDetailVO> partnerStaffDetailVOIPage = tPartnerStaffDao.listByPage(resultPage, param);

        List<PartnerStaffDetailVO> records = partnerStaffDetailVOIPage.getRecords();
        QueryWrapper<TPartnerCertificate> queryWrapper = new QueryWrapper<>();

        for (PartnerStaffDetailVO record : records) {
            queryWrapper.clear();
            queryWrapper.eq("biz_id", record.getId());
            queryWrapper.eq("status", StatusEnum.USE.getCode());
            List<TPartnerCertificate> tPartnerCertificates = tPartnerCertificateService.list(queryWrapper);
            Date validEndDate = tPartnerCertificates.stream().map(TPartnerCertificate::getValidEndDate).filter(date -> date.compareTo(new Date())<0 ).findAny().orElse(null);
            if (validEndDate != null) {
                record.setCertificateStatus(0);
            } else {
                record.setCertificateStatus(1);
            }
        }
        List<PartnerStaffDetailVO> partnerStaffDetailVOS =
                records.stream().filter(partnerStaffDetailVO -> {
                    if (ObjectUtil.isEmpty(param.getCertificateStatus())) {
                        return true;
                    } else {
                        return partnerStaffDetailVO.getCertificateStatus().equals(param.getCertificateStatus());
                    }
                }).collect(Collectors.toList());
        partnerStaffDetailVOIPage.setRecords(partnerStaffDetailVOS);
        return partnerStaffDetailVOIPage;
    }

    @Override
    public PartnerStaffDetailVO getPartnerStaffDetail(String id) {
        List<PartnerStaffDetailVO> partnerStaffDetailVOList = tPartnerStaffDao.getPartnerStaffDetail(id);
        PartnerStaffDetailVO partnerStaffDetail = partnerStaffDetailVOList.get(partnerStaffDetailVOList.size() - 1);
        if (!ObjectUtils.isEmpty(partnerStaffDetail)) {
            // 关联资质
            QueryWrapper<TPartnerCertificate> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("biz_id", partnerStaffDetail.getId());
            queryWrapper.eq("status", StatusEnum.USE.getCode());
            partnerStaffDetail.setCertificateIdList(tPartnerCertificateService.list(queryWrapper));
        }

        return partnerStaffDetail;
    }

    @Autowired
    private TPartnerOrgService tPartnerOrgService;

    @Autowired
    private SysDictDataService sysDictDataService;

    @SneakyThrows
    @Override
    @Transactional(rollbackFor = Throwable.class)
    public BaseResponse<String> importPersonnel(MultipartFile file) {
        BaseResponse<String> baseResponse = new BaseResponse<>();
        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        //判断是否为null
        if (file.equals("") || file.getSize() <= 0) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("上传文件数据错误");
            return baseResponse;
        }
        final String[] staffId = {""};
        final String[] orgId = {""};
        final String[] partnerId = {""};
        EasyExcel.read(file.getInputStream(), PartnerStaffImport.class, new AnalysisEventListener<PartnerStaffImport>() {
            @SneakyThrows
            @Override
            public void invoke(PartnerStaffImport partnerStaffImport, AnalysisContext analysisContext) {

                ReadRowHolder readRowHolder = analysisContext.readRowHolder();
                Integer rowIndex = readRowHolder.getRowIndex();
                //从第二行开始读取
                if (rowIndex > 5) {
                    rowIndex += 1;
                    if (partnerStaffImport.getStaffName() != null) {
                        TPartnerStaffDTO tPartnerStaffDTO = new TPartnerStaffDTO();
                        tPartnerStaffDTO.setLoginName(partnerStaffImport.getLoginName());
                        SysOrg sysOrg = null;
                        //存放机构id
                        //如果企业名称不为空，存放id，供其他为null的使用
                        if (partnerStaffImport.getOrgName() != null && partnerStaffImport.getOrgName() != "") {
                            sysOrg = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq("org_name", partnerStaffImport.getOrgName()).eq("status", "0"));
                            if (sysOrg == null) {
                                throw new BusinessException("第[" + rowIndex + "]行，公司：[" + partnerStaffImport.getOrgName() + "]不存在");
                            } else {
                                tPartnerStaffDTO.setOrgId(sysOrg.getOrgId());
                                orgId[0] = sysOrg.getOrgId();
                            }
                        }
                        //存放相关单位
                        //如果相关单位名称不为空，存放单位id，供其他为null的使用
                        if (partnerStaffImport.getPartnerName() != null && partnerStaffImport.getPartnerName() != "") {
                            TPartnerOrg tPartnerOrg = tPartnerOrgService.getOne(new QueryWrapper<TPartnerOrg>().eq("name", partnerStaffImport.getPartnerName()).eq("credit_code", partnerStaffImport.getCreditCode()).eq("status", "0"));
                            if (tPartnerOrg == null) {
                                throw new BusinessException("第[" + rowIndex + "]行，相关单位[" + partnerStaffImport.getPartnerName() + "]不存在或相关单位与统一社会信用代码不匹配");
                            } else {
                                partnerId[0] = tPartnerOrg.getId();
                                tPartnerStaffDTO.setPartnerId(partnerId[0]);
                            }
                        }
                        //存放人员姓名
                        tPartnerStaffDTO.setName(partnerStaffImport.getStaffName());
                        //校验身份证
                        boolean checkIdCard = IdcardUtil.isValidCard(partnerStaffImport.getIdcard());
                        if (!checkIdCard) {
                            throw new BusinessException("第[" + rowIndex + "]行，身份证" + partnerStaffImport.getIdcard() + "格式不正确");
                        }
                        //校验身份
                        boolean checkResult = checkPartnerStaff(null, partnerStaffImport.getIdcard(), partnerId[0]);
                        if (!checkResult) {
                            throw new BusinessException("第[" + rowIndex + "]行，身份证" + "已存在相同的身份证信息为:" + partnerStaffImport.getIdcard() + "的员工");
                        }
                        //存放身份证号
                        tPartnerStaffDTO.setIdcard(partnerStaffImport.getIdcard());
                        //存放联系方式
                        tPartnerStaffDTO.setPhone(partnerStaffImport.getPhone());
                        //存放账号
                        tPartnerStaffDTO.setLoginName(partnerStaffImport.getLoginName());
                        //校验角色
                        QueryWrapper<SysRole> roleAllQuery = new QueryWrapper();
                        roleAllQuery.select("role_id");
                        roleAllQuery.ne("status", "1");
                        roleAllQuery.eq("tree_level", sysOrg.getTreeLevel());
                        List<Object> roleIds = sysRoleService.listObjs(roleAllQuery);
                        SysRole sysRole = sysRoleService.getOne(new QueryWrapper<SysRole>().in(roleIds != null && roleIds.size() > 0, "role_id", roleIds).eq("role_name", partnerStaffImport.getRole()).eq("status", "0"));
                        if (sysRole == null) {
                            throw new BusinessException("第[" + rowIndex + "]行，角色" + partnerStaffImport.getRole() + "不存在");
                        }
                        //存放角色id
                        String[] addRoleIds = new String[]{sysRole.getRoleId()};
                        tPartnerStaffDTO.setRoleIds(addRoleIds);
                        //存放工种
                        tPartnerStaffDTO.setWorkType(partnerStaffImport.getWorkType());
                        //初始化资质内容
                        List<TPartnerCertificateDTO> tPartnerCertificateDTOS = new ArrayList<>();
                        TPartnerCertificateDTO tPartnerCertificateDTO = new TPartnerCertificateDTO();
                        tPartnerCertificateDTO.setCode(partnerStaffImport.getCode());
                        tPartnerCertificateDTO.setName(partnerStaffImport.getCertificateName());
                        tPartnerCertificateDTO.setRemarks(partnerStaffImport.getRemarks());
                        String validEndDate = partnerStaffImport.getValidEndDate();
                        if (StrUtil.isNotBlank(validEndDate)) {
                            // 尝试不同的日期格式
                            String[] dateFormats = {"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "MM/dd/yyyy", "dd-MM-yyyy"};

                            Date localDate = null;
                            for (String dateFormat : dateFormats) {
                                try {
                                    SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                                    localDate = formatter.parse(validEndDate);
                                    break; // 如果成功解析，跳出循环
                                } catch (DateTimeParseException e) {
                                    // 如果解析失败，继续下一个格式的尝试
                                }
                            }
                            tPartnerCertificateDTO.setValidEndDate(localDate);
                        }
                        SysDictData sysDictData = sysDictDataService.getOne(new QueryWrapper<SysDictData>().eq("dict_id", "0fd46a11a1224a9e9ceda05cf9bbeee3").eq("status", "0").eq("dict_value", partnerStaffImport.getCertificateName()));
                        if (sysDictData == null) {
                            throw new BusinessException("第[" + rowIndex + "]行，证件:" + partnerStaffImport.getCertificateName() + "不存在");
                        }
                        tPartnerCertificateDTO.setName(sysDictData.getDictKey());
                        tPartnerCertificateDTOS.add(tPartnerCertificateDTO);
                        tPartnerStaffDTO.setCertificateIdList(tPartnerCertificateDTOS);
                        TPartnerStaff data = editPartnerStaff(tPartnerStaffDTO).getData();
                        if (data != null) {
                            //存入人员id
                            staffId[0] = data.getId();
                        }

                    }
                    //如果是空的证明还是上一行人员的资质
                    else {
                        TPartnerStaffDTO tPartnerStaffDTO = new TPartnerStaffDTO();
                        //初始化资质内容
                        List<TPartnerCertificateDTO> tPartnerCertificateDTOS = new ArrayList<>();
                        TPartnerCertificateDTO tPartnerCertificateDTO = new TPartnerCertificateDTO();
                        tPartnerCertificateDTO.setCode(partnerStaffImport.getCode());
                        tPartnerCertificateDTO.setRemarks(partnerStaffImport.getRemarks());
                        String validEndDate = partnerStaffImport.getValidEndDate();
                        if (StrUtil.isNotBlank(validEndDate)) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                            Date dateParam = df.parse(validEndDate);
                            tPartnerCertificateDTO.setValidEndDate(dateParam);
                        }
                        SysDictData sysDictData = sysDictDataService.getOne(new QueryWrapper<SysDictData>().eq("dict_id", "0fd46a11a1224a9e9ceda05cf9bbeee3").eq("status", "0").eq("dict_value", partnerStaffImport.getCertificateName()));
                        if (sysDictData == null) {
                            throw new BusinessException("第[" + rowIndex + "]行，证件:" + partnerStaffImport.getCertificateName() + "不存在");
                        }
                        tPartnerCertificateDTO.setName(sysDictData.getDictKey());
                        tPartnerCertificateDTO.setBizId(staffId[0]);
                        tPartnerStaffDTO.setCertificateIdList(tPartnerCertificateDTOS);
                        editPartnerStaff(tPartnerStaffDTO);
                    }
                }
            }

            @Override
            public void doAfterAllAnalysed(AnalysisContext analysisContext) {

            }
        }).sheet().doRead();
        baseResponse.setData("成功");
        return baseResponse;
    }
}
