package com.testor.module.safe.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 巡检排查标准管理对象 t_safe_hazard_standard_type
 *
 * @author testor-framework
 * @date 2022-08-08 10:55:55
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_standard_type")
@ApiModel(value = "TSafeHazardStandardType对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardStandardType extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")
    @TableField("ref_id")
    private String refId;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId;

    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId;

    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus;

    /**
     * 标准分类名称
     */
    @ApiModelProperty(value = "标准分类名称")
    @TableField("name")
    private String name;

    /**
     * 具体分类项
     */
    @ApiModelProperty(value = "具体分类项")
    @TableField("category_item")
    private String categoryItem;

    /**
     * 是否系统内置（0-否；1-是）
     */
    @ApiModelProperty(value = "是否系统内置（0-否；1-是）")
    @TableField("built_in")
    private String builtIn;

    /**
     * 整改前后照片（0-非必填；1-必填）
     */
    @ApiModelProperty(value = "整改前后照片（0-非必填；1-必填）")
    @TableField("image")
    private String image;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", example = "0")
    @TableField("sort")
    private Integer sort;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别", example = "0")
    @TableField("\"level\"")
    private Integer level;

    @ApiModelProperty(value = "整改前防范措施（0-非必填；1-必填）")
    @TableField("precautions")
    private String precautions;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String NAME = "name";
    public static final String CATEGORY_ITEM = "category_item";
    public static final String BUILT_IN = "built_in";
    public static final String IMAGE = "image";
    public static final String SORT = "sort";
    public static final String LEVEL = "\"level\"";
}
