package com.testor.module.safeCheck.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.testor.module.safeCheck.model.domain.TSafeCheckTaskPostpone;
import com.testor.module.safeCheck.model.vo.TSafeCheckTaskRecordVo;
import com.testor.module.safeCheck.model.vo.TSafeCheckTaskVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.safeCheck.model.domain.TSafeCheckTask;
import com.testor.module.safeCheck.model.dto.TSafeCheckTaskParam;
import com.testor.module.safeCheck.model.dto.TSafeCheckTaskDelParam;
import com.testor.module.safeCheck.service.TSafeCheckTaskService;

/**
 * 安全检查计划任务Controller
 *
 * @author testor-framework
 * @date 2024-09-03 08:04:19
 */
@RestController
@RequestMapping("/safeCheck/task")
@Api(value = "TSafeCheckTask", tags = "安全检查计划任务")
@Slf4j
public class TSafeCheckTaskController extends SuperController
{
    @Autowired
    private TSafeCheckTaskService tSafeCheckTaskService;


	@ApiOperation(value = "获取 安全检查计划任务 ", notes = "Get TSafeCheckTask By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeCheckTaskVo> getById(String id){
		BaseResponse<TSafeCheckTaskVo> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TSafeCheckTaskVo data= tSafeCheckTaskService.details(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "下发 安全检查计划任务 ")
	@GetMapping(value = "/allots")
	public BaseResponse<TSafeCheckTask> allots(){
		BaseResponse<TSafeCheckTask> baseResponse=new BaseResponse<>();
		tSafeCheckTaskService.createCheckTaskExecutor();
		return baseResponse;
	}

	@ApiOperation(value = "修改 安全检查计划任务 ", notes = "Update TSafeCheckTask By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeCheckTask updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeCheckTask data=BeanHelper.beanToBean(updateRequest, TSafeCheckTask.class);
			boolean result= tSafeCheckTaskService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "延期 ", notes = "Add TSafeCheckTaskPostpone")
	@PutMapping(value = "/postponed")
	public BaseResponse<BizGeneralResponse> postponed(@RequestBody TSafeCheckTaskPostpone  addRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
			boolean result= tSafeCheckTaskService.postponed(addRequest);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());

		return baseResponse;
	}

	@ApiOperation(value = "完成任务", notes = "Add TSafeCheckTaskPostpone")
	@PostMapping(value = "/completeTask")
	public BaseResponse<Boolean>completeTask(@RequestBody TSafeCheckTaskRecordVo addRequest) {
		BaseResponse<Boolean> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			boolean result= tSafeCheckTaskService.completeTask(addRequest);
			baseResponse.setData(result);
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 安全检查计划任务 ", notes = "delete TSafeCheckTask By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeCheckTaskDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeCheckTask data= new TSafeCheckTask();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSafeCheckTaskService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除安全检查计划任务", notes = "delete TSafeCheckTask by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSafeCheckTaskDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSafeCheckTask> tSafeCheckTaskList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSafeCheckTask data= new TSafeCheckTask();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSafeCheckTaskList.add(data);
			}
			boolean result = tSafeCheckTaskService.updateBatchById(tSafeCheckTaskList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查计划任务 分页列表", notes = "List TSafeCheckTask with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeCheckTask>>listEntity(TSafeCheckTaskParam param){
		BaseResponse<BaseResponseList<TSafeCheckTask>>baseResponse=new BaseResponse<>();
		Page<TSafeCheckTask> resultList= tSafeCheckTaskService.pageList(param);
		BaseResponseList<TSafeCheckTask> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查计划任务 列表", notes = "List TSafeCheckTask all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSafeCheckTask>>listAllEntity(TSafeCheckTaskParam param){
		BaseResponse<BaseResponseList<TSafeCheckTask>>baseResponse=new BaseResponse<>();
		List<TSafeCheckTask> resultList=tSafeCheckTaskService.listList(param);
		BaseResponseList<TSafeCheckTask> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}


}
