package com.testor.module.train.examinationManage.controller;

import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.biz.sys.dict.data.controller.SysDictDataController;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataResponse;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.model.dto.TreeVO;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.model.dto.SysUserListResponse;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.common.util.DateUtil;
import com.testor.module.train.myManagement.service.TTrainMyManagementService;
import com.testor.module.train.project.controller.TTrainProjectScan;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.train.examinationManage.model.domain.TTrainExaminationManage;
import com.testor.module.train.examinationManage.model.dto.TTrainExaminationManageParam;
import com.testor.module.train.examinationManage.model.dto.TTrainExaminationManageDelParam;
import com.testor.module.train.examinationManage.service.TTrainExaminationManageService;
import org.springframework.web.bind.annotation.*;

import static java.util.stream.Collectors.toList;

/**
 * 考试管理—安全培训教育Controller
 *
 * @author testor-framework
 * @date 2022-09-07 11:43:25
 */
@RestController
@RequestMapping("/manage")
@Api(value = "TTrainExaminationManage", tags = "安全培训教育——考试管理")
@Slf4j
public class TTrainExaminationManageController extends SuperController {
    @Autowired
    private TTrainExaminationManageService tTrainExaminationManageService;
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private TTrainMyManagementService tTrainMyManagementService;
    @Autowired
    private TTrainProjectScan tTrainProjectScan;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysDictDataController sysDictDataController;

    /* Generated Method*/
    @ApiOperation(value = "新增 编辑 考试管理—安全培训教育", notes = "保存补考记录时parentId传上一个考试的id  is_repair 传1 ")
    @PostMapping(value = "/add")
    public BaseResponse<Map<String,String>> addEntity(@RequestBody TTrainExaminationManageParam addRequest) throws Exception{
        return tTrainExaminationManageService.addEntity(addRequest);
    }

//    @ApiOperation(value = "【根据当前登录用户id获取子组织机构树及子部门信息】 ", notes = "")
//    @GetMapping(value = "/getOrgAndTree1")
//    public BaseResponse<List<TreeVO>> getOrgAndTree1(String orgId) {
//        BaseResponse<List<TreeVO>> baseResponse = new BaseResponse<>();
//        List<TreeVO> cildren = getCildren(orgId);
//        baseResponse.setData(cildren);
//        return baseResponse;
//    }
//
//    private List<TreeVO>  getCildren(String orgId) {
//        List<SysOrg> list1 = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.PARENT_ID, orgId)
//                .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE));
//        List<TreeVO> treeVOS = new ArrayList<>();
//        for (SysOrg sysOrg : list1) {
//            TreeVO treeVO = BeanHelper.beanToBean(sysOrg, TreeVO.class);
//            treeVOS.add(treeVO);
//        }
//        for (TreeVO treeVO : treeVOS) {
//            treeVO.setChildren(getCildren(treeVO.getOrgId()));
//        }
//        return treeVOS;
//    }

    @ApiOperation(value = "【根据当前登录用户id获取子组织机构树及子部门信息】 ", notes = "")
    @GetMapping(value = "/getOrgAndTree")
    public BaseResponse<TreeVO> getOrgAndTree(String orgId) {
        BaseResponse<TreeVO> baseResponse = new BaseResponse<>();
        List<SysOrg> list = sysOrgService.list(new QueryWrapper<SysOrg>()
                .eq(SysOrg.ORG_ID, orgId)
                .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE)
        );
        TreeVO treeVO = null;
        for (SysOrg sysOrg : list) {
            treeVO = BeanHelper.beanToBean(sysOrg, TreeVO.class);
            List<SysOrg> list1 = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.PARENT_ID, treeVO.getOrgId())
                    .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE).orderByDesc(SysOrg.IS_DEPT));
            List<TreeVO> treeVOS = new ArrayList<>();
            for (SysOrg org : list1) {
                TreeVO treeVO1 = BeanHelper.beanToBean(org, TreeVO.class);
                List<SysOrg> list2 = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.PARENT_ID, treeVO1.getOrgId())
                        .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE).orderByDesc(SysOrg.IS_DEPT));
                List<TreeVO> treeVOS1 = new ArrayList<>();
                for (SysOrg sysOrg1 : list2) {
                    TreeVO treeVO2 = BeanHelper.beanToBean(sysOrg1, TreeVO.class);
                    List<SysOrg> list3 = sysOrgService.list(new QueryWrapper<SysOrg>().eq(SysOrg.PARENT_ID, treeVO2.getOrgId())
                            .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE).orderByDesc(SysOrg.IS_DEPT));
                    List<TreeVO> treeVOSs = new ArrayList<>();
                    for (SysOrg sysOrg2 : list3) {
                        TreeVO treeVO3 = BeanHelper.beanToBean(sysOrg2, TreeVO.class);
                        treeVOSs.add(treeVO3);
                    }
                    treeVO2.setChildren(treeVOSs);
                    treeVOS1.add(treeVO2);
                }
                treeVO1.setChildren(treeVOS1);
                treeVOS.add(treeVO1);
            }
            treeVO.setChildren(treeVOS);
        }
        baseResponse.setData(treeVO);
        return baseResponse;
    }


    @ApiOperation(value = "随机线上添加考试", notes = "")
    @GetMapping(value = "/randomAdd")
    public BaseResponse<TTrainExaminationManage> randomAdd(String id) throws Exception{
        return tTrainExaminationManageService.randomAdd(id);
    }

    @ApiOperation(value = "获取 考试管理—安全培训教育 ", notes = "Get TTrainExaminationManage By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TTrainExaminationManageParam> getById(String id) {
        return tTrainExaminationManageService.getByIds(id);
    }

    @ApiOperation(value = "获取 考试管理—安全培训教育 ", notes = "Get TTrainExaminationManage By Id")
    @GetMapping(value = "/select")
    public BaseResponse<TTrainExaminationManageParam> getByCondition(@RequestParam("id") String id,
                                                             @RequestParam(value = "orgId", required = false) String orgId,
                                                             @RequestParam(value = "name", required = false) String name,
                                                             @RequestParam(value = "status", required = false) String status) {
        return tTrainExaminationManageService.getByCondition(id,orgId,name,status);
    }


    @ApiOperation(value = "删除 考试管理—安全培训教育 ", notes = "delete TTrainExaminationManage By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TTrainExaminationManageDelParam deleteRequest) throws Exception{
        return tTrainExaminationManageService.deleteEntity(deleteRequest);
    }

    @ApiOperation(value = "添加补考 ", notes = "Get TTrainExaminationManage By Id")
    @GetMapping(value = "/addRepairExam")
    public BaseResponse<TTrainExaminationManageParam> addRepairExam(String id) {
        return tTrainExaminationManageService.addRepairExam(id);
    }

    @ApiOperation(value = "相关补考 ", notes = "Get TTrainExaminationManage By Id")
    @GetMapping(value = "/relevantRepairExam")
    public BaseResponse<TTrainExaminationManageParam> relevantRepairExam(String id) {
        return tTrainExaminationManageService.relevantRepairExam(id);
    }


    @ApiOperation(value = "获取 考试管理—安全培训教育 分页列表", notes = "List TTrainExaminationManage with page")
    @PostMapping(value = "/list")
    public BaseResponse<BaseResponseList<TTrainExaminationManageParam>> listEntity(@RequestBody TTrainExaminationManageParam param) throws Exception{
        BaseResponse<BaseResponseList<TTrainExaminationManageParam>> baseResponse = new BaseResponse<>();
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        String parentIds = sysOrg.getParentIds();
        String orgId = sysOrg.getOrgId();
        if (ObjectHelper.isNotEmpty(param.getExamStartTime())) {
            //String startTime = param.getExamStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String startTime =  DateUtil.convertDateToStr(param.getExamStartTime(), "yyyy-MM-dd HH:mm:ss");
            param.setStartTime(startTime);
        }
        if (ObjectHelper.isNotEmpty(param.getExamEndTime())) {
           // String endTime = param.getExamEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String endTime =  DateUtil.convertDateToStr(param.getExamEndTime(), "yyyy-MM-dd HH:mm:ss");
            param.setEndTime(endTime);
        }
        IPage<TTrainExaminationManageParam> affiliation = tTrainExaminationManageService.getExamAffiliation(param, parentIds, orgId);
        List<TTrainExaminationManageParam> records = affiliation.getRecords();
        List<TTrainExaminationManageParam> tTrainProjectParams2 = new ArrayList<>();
        if (records.size() > 0) {
            // 按计划名称进行分组
            Map<String, List<TTrainExaminationManageParam>> collect = records.stream().collect(Collectors.groupingBy(TTrainExaminationManageParam::getId));
            for (String s : collect.keySet()) {
                // 每一条计划关联的人
                List<TTrainExaminationManageParam> tTrainProjectParams =  tTrainExaminationManageService.getExamProjectPerson(s);
                // 随机考试新建计划人员为0
                if (tTrainProjectParams.size() == 0) {
                    TTrainExaminationManage one = tTrainExaminationManageService.getById(s);
                    TTrainExaminationManageParam tTrainExaminationManageParam = BeanHelper.beanToBean(one, TTrainExaminationManageParam.class);
                    tTrainExaminationManageParam.setPercentage("0");
                    tTrainProjectParams.add(tTrainExaminationManageParam);
                }
                // 存储完成率
                List<String> saveFinish = saveFinish(tTrainProjectParams);
                // 拼接后每一条计划关联的人
                List<TTrainExaminationManageParam> tTrainProjectParams1 = new ArrayList<>();
                for (TTrainExaminationManageParam record : tTrainProjectParams) {
                    TTrainExaminationManageParam tTrainProjectParam = BeanHelper.beanToBean(record, TTrainExaminationManageParam.class);
                    String affiliation1 = "";
                    if ("1".equals(record.getPersonAffiliation())) {
                        affiliation1 = "内部单位";
                    } else if ("2".equals(record.getPersonAffiliation())) {
                        affiliation1 = "相关方";
                    }
                    String company = affiliation1 + "-" + record.getCompany();
                    // 存储计划完成率
                    record.setPercentage(saveFinish.get(2));
                    record.setFinishNumber(saveFinish.get(1));
                    record.setShouldTestNumber(saveFinish.get(0));
                    tTrainProjectParam.setPersonAffiliation(company);
                    tTrainProjectParams1.add(tTrainProjectParam);
                }
                // 获取一个计划
                TTrainExaminationManageParam tTrainProjectParam = tTrainProjectParams1.get(0);
                SysDictDataResponse materials2 = sysDictDataController.getDictTypeDetail("", "EXAM_TYPE", tTrainProjectParam.getExamType()).getData();
                if (ObjectHelper.isNotEmpty(materials2)) {
                    String materials = materials2.getDictValue();
                    tTrainProjectParam.setExamType(materials);
                }
                if ("3".equals(tTrainProjectParam.getExamWay()) && StringHelper.isEmpty(tTrainProjectParam.getQrCode())) {
                    String str = "扫码考试";
                    BaseResponse<FileDTO> fileDTOBaseResponse = tTrainProjectScan.scanProject(tTrainProjectParam.getId(),str);
                    String filePath = fileDTOBaseResponse.getData().getFilePath();
                    tTrainExaminationManageService.update(new UpdateWrapper<TTrainExaminationManage>()
                            .eq(TTrainExaminationManage.ID, tTrainProjectParam.getId())
                            .set(TTrainExaminationManage.QR_CODE, filePath)
                    );
                }
                String personAffiliation = "";
                for (TTrainExaminationManageParam trainProjectParam : tTrainProjectParams1) {
                    if(!personAffiliation.contains(trainProjectParam.getPersonAffiliation())){
                        personAffiliation += trainProjectParam.getPersonAffiliation() + " ";
                    }
                }
                tTrainProjectParam.setPersonAffiliation(personAffiliation);
                tTrainProjectParams2.add(tTrainProjectParam);
            }
            tTrainProjectParams2 = tTrainProjectParams2.stream().sorted(Comparator.comparing(TTrainExaminationManageParam::getCreateDate).reversed()).collect(toList());
        }
        BaseResponseList<TTrainExaminationManageParam> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(tTrainProjectParams2);
        baseResponseList.setTotal(affiliation.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "根据部门id获取人员", notes = "获取部门下的人员信息")
    @PostMapping(value = "/getPerson")
    public BaseResponse<List<SysUserListResponse>> getPerson(@RequestBody TTrainExaminationManageParam examinationManageParam) {
        String companyIds = examinationManageParam.getCompanyIds();
        String[] orgIds = companyIds.split(",");
        BaseResponse<List<SysUserListResponse>> baseResponse = new BaseResponse<>();
        List<SysUser> list = sysUserService.list(new QueryWrapper<SysUser>()
                .in(SysUser.DEPT_ID, orgIds)
                .ne(SysUser.STATUS, BizConstants.STATUS_DELETE)
        );
        List<SysUserListResponse> collect = list.stream().map(bean -> bean.beanToBean(SysUserListResponse.class)).collect(toList());
        collect.stream().forEach(item->{
            item.setEmail("1");
            item.setDeptName(item.getOrgName());
            item.setOrgName(sysOrgService.getById(item.getOrgId()).getOrgName());
        });
        baseResponse.setData(collect);
        return baseResponse;
    }
    /**
     * 存储完成率
     *
     * @param tTrainProjectParams
     */
    private List<String> saveFinish(List<TTrainExaminationManageParam> tTrainProjectParams) {
        // 应考人数
        int size = tTrainProjectParams.size();
        // 未参与人数
        int count = 0;
        // 通过的人数
        int pass = 0 ;
        // 计划id
        String id = null;
        for (TTrainExaminationManageParam tTrainProjectParam : tTrainProjectParams) {
            // 获取该考试所对应的补考计划
//            TTrainExaminationManage one = tTrainExaminationManageService.getOne(new QueryWrapper<TTrainExaminationManage>()
//                    .eq(TTrainExaminationManage.PARENT_ID, tTrainProjectParam.getId())
//                    .ne(TTrainExaminationManage.STATUS, BizConstants.STATUS_DELETE)
//            );
//            String oneId = "";
//            if (ObjectHelper.isNotEmpty(one)) {
//                oneId = one.getId();
//            }
            // 补考计划所对应的成绩信息
//            TTrainMyManagement one1 = tTrainMyManagementService.getOne(new QueryWrapper<TTrainMyManagement>()
//                    .eq(TTrainMyManagement.TASK_ID, oneId)
//                    .eq(TTrainMyManagement.PERSON_ID, ContextUtils.getLoginUser().getUserId())
//                    .ne(TTrainMyManagement.STATUS, BizConstants.STATUS_DELETE)
//            );
            id = tTrainProjectParam.getId();
            //学习情况(仅当为考试计划时 0 待考试 1 通过 2 未通过)
            String percentage = tTrainProjectParam.getPercentage();
            if ("0".equals(percentage)) {
                count++;
            }
            String percentage1 = "";
//            if (ObjectHelper.isNotEmpty(one1)) {
//                percentage1 = one1.getPercentage();
//            }
            if ("1".equals(percentage) || "1".equals(percentage1)) {
                pass ++ ;
            }
        }
        // 参与的人数
        int take = size - count ;

        // 完成率
        String percentage = getRatio(pass, take);
        tTrainExaminationManageService.update(new UpdateWrapper<TTrainExaminationManage>()
                .eq(TTrainExaminationManage.ID, id)
                .set(TTrainExaminationManage.SHOULD_TEST_NUMBER, size)
                // 参与人数
                .set(TTrainExaminationManage.FINISH_NUMBER, take)
                .set(TTrainExaminationManage.PERCENTAGE, percentage)
        );
        List<String> list = new ArrayList<>();
        list.add(Integer.toString(size));
        list.add(Integer.toString(take));
        list.add(percentage);
        return list;

    }

    /**
     * 计算完成率
     * @param number1
     * @param number2
     * @return
     */
    public static String getRatio(Integer number1, Integer number2) {
        DecimalFormat df = new DecimalFormat("0.0");
        if (number2 != 0) {
            return df.format((float) (number1 / (double) number2) * 100) + "%";
        } else {
            return "0%";
        }
    }


    //    @ApiOperation(value = "修改 考试管理—安全培训教育 ", notes = "Update TTrainExaminationManage By Id")
//    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TTrainExaminationManage updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TTrainExaminationManage data = BeanHelper.beanToBean(updateRequest, TTrainExaminationManage.class);
            boolean result = tTrainExaminationManageService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

//    @ApiOperation(value = "批量删除考试管理—安全培训教育", notes = "delete TTrainExaminationManage by batch Id")
//    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TTrainExaminationManageDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TTrainExaminationManage> tTrainExaminationManageList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TTrainExaminationManage data = new TTrainExaminationManage();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tTrainExaminationManageList.add(data);
            }
            boolean result = tTrainExaminationManageService.updateBatchById(tTrainExaminationManageList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

//    @ApiOperation(value = "获取 考试管理—安全培训教育 列表", notes = "List TTrainExaminationManage all")
//    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TTrainExaminationManage>> listAllEntity(TTrainExaminationManageParam param) {
        BaseResponse<BaseResponseList<TTrainExaminationManage>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TTrainExaminationManage> queryWrapper = this.createQuery(param);
        List<TTrainExaminationManage> resultList = tTrainExaminationManageService.list(queryWrapper);
        BaseResponseList<TTrainExaminationManage> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TTrainExaminationManage> createQuery(TTrainExaminationManageParam queryParam) {
        QueryWrapper<TTrainExaminationManage> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getIsRepair())) {
            queryWrapper.eq(TTrainExaminationManage.IS_REPAIR, queryParam.getIsRepair());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TTrainExaminationManage.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getExamName())) {
            queryWrapper.like(TTrainExaminationManage.EXAM_NAME, queryParam.getExamName());
        }
        if (StringHelper.isNotEmpty(queryParam.getExamWay())) {
            queryWrapper.eq(TTrainExaminationManage.EXAM_WAY, queryParam.getExamWay());
        }
        if (StringHelper.isNotEmpty(queryParam.getExamType())) {
            queryWrapper.eq(TTrainExaminationManage.EXAM_TYPE, queryParam.getExamType());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getExamStartTime())) {
            queryWrapper.eq(TTrainExaminationManage.EXAM_START_TIME, queryParam.getExamStartTime());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getExamEndTime())) {
            queryWrapper.eq(TTrainExaminationManage.EXAM_END_TIME, queryParam.getExamEndTime());
        }
        if (StringHelper.isNotEmpty(queryParam.getPaperId())) {
            queryWrapper.eq(TTrainExaminationManage.PAPER_ID, queryParam.getPaperId());
        }
        if (StringHelper.isNotEmpty(queryParam.getExamDuration())) {
            queryWrapper.eq(TTrainExaminationManage.EXAM_DURATION, queryParam.getExamDuration());
        }
        if (StringHelper.isNotEmpty(queryParam.getExamSite())) {
            queryWrapper.eq(TTrainExaminationManage.EXAM_SITE, queryParam.getExamSite());
        }
        if (StringHelper.isNotEmpty(queryParam.getShouldTestNumber())) {
            queryWrapper.eq(TTrainExaminationManage.SHOULD_TEST_NUMBER, queryParam.getShouldTestNumber());
        }
        if (StringHelper.isNotEmpty(queryParam.getFinishNumber())) {
            queryWrapper.eq(TTrainExaminationManage.FINISH_NUMBER, queryParam.getFinishNumber());
        }
        if (StringHelper.isNotEmpty(queryParam.getPercentage())) {
            queryWrapper.eq(TTrainExaminationManage.PERCENTAGE, queryParam.getPercentage());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgName())) {
            queryWrapper.like(TTrainExaminationManage.ORG_NAME, queryParam.getOrgName());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TTrainExaminationManage.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TTrainExaminationManage.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TTrainExaminationManage.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TTrainExaminationManage.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TTrainExaminationManage.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TTrainExaminationManage.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TTrainExaminationManage.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
