/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.admin.apis.biz.gen.util;

import com.tongtech.tfw.backend.admin.apis.biz.gen.GenConstants;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTable;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTableColumn;
import com.tongtech.tfw.backend.admin.apis.config.GenConfig;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import java.util.Arrays;

public class GenUtils {
    public static void initTable(GenTable genTable, String operName) {
        genTable.setClassName(GenUtils.convertClassName(genTable.getTableName()));
        genTable.setPackageName(GenConfig.getPackageName());
        genTable.setModuleName(GenUtils.getModuleName(GenConfig.getPackageName()));
        genTable.setBusinessName(GenUtils.getBusinessName(genTable.getTableName()));
        genTable.setFunctionName(GenUtils.replaceText(genTable.getTableComment()));
        genTable.setFunctionAuthor(GenConfig.getAuthor());
        genTable.setCreateBy(operName);
    }

    public static void initColumnField(GenTableColumn column, GenTable table) {
        String dataType = GenUtils.getDbType(column.getColumnType());
        String columnName = column.getColumnName();
        column.setTableId(table.getTableId());
        column.setCreateBy(table.getCreateBy());
        column.setJavaField(StringHelper.toCamelCase((String)columnName));
        if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_STR, dataType)) {
            column.setJavaType("String");
            Integer columnLength = GenUtils.getColumnLength(column.getColumnType());
            String htmlType = columnLength >= 500 ? "textarea" : "input";
            column.setHtmlType(htmlType);
        } else if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_TIME, dataType)) {
            column.setJavaType("LocalDateTime");
            column.setHtmlType("datetime");
        } else if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_NUMBER, dataType)) {
            column.setHtmlType("input");
            String[] str = StringHelper.split((String)StringHelper.substringBetween((String)column.getColumnType(), (String)"(", (String)")"), (String)",");
            if (str.length == 2 && Integer.parseInt(str[1]) > 0) {
                column.setJavaType("Double");
            } else if (str.length == 1 && Integer.parseInt(str[0]) <= 10) {
                column.setJavaType("Integer");
            } else {
                column.setJavaType("Long");
            }
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_INSERT, columnName) && !column.isPk()) {
            column.setIsInsert("1");
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_EDIT, columnName) && !column.isPk()) {
            column.setIsEdit("1");
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_LIST, columnName) && !column.isPk()) {
            column.setIsList("1");
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_QUERY, columnName) && !column.isPk()) {
            column.setIsQuery("1");
        }
        if (StringHelper.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"name")) {
            column.setQueryType("LIKE");
        }
        if (StringHelper.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"status")) {
            column.setHtmlType("radio");
        } else if (StringHelper.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"type") || StringHelper.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"sex")) {
            column.setHtmlType("select");
        }
    }

    public static boolean arraysContains(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static String getModuleName(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        int nameLength = packageName.length();
        String moduleName = StringHelper.substring((String)packageName, (int)(lastIndex + 1), (int)nameLength);
        return moduleName;
    }

    public static String getBusinessName(String tableName) {
        int lastIndex = tableName.lastIndexOf("_");
        int nameLength = tableName.length();
        String businessName = StringHelper.substring((String)tableName, (int)(lastIndex + 1), (int)nameLength);
        return businessName;
    }

    public static String convertClassName(String tableName) {
        boolean autoRemovePre = GenConfig.getAutoRemovePre();
        String tablePrefix = GenConfig.getTablePrefix();
        if (autoRemovePre && StringHelper.isNotEmpty((CharSequence)tablePrefix)) {
            String[] searchList = StringHelper.split((String)tablePrefix, (String)",");
            tableName = GenUtils.replaceFirst(tableName, searchList);
        }
        return StringHelper.convertToCamelCase((String)tableName);
    }

    public static String replaceFirst(String replacementm, String[] searchList) {
        String text = replacementm;
        for (String searchString : searchList) {
            if (!replacementm.startsWith(searchString)) continue;
            text = replacementm.replaceFirst(searchString, "");
            break;
        }
        return text;
    }

    public static String replaceText(String text) {
        return StringHelper.replaceAllWithRegex((String)text, (String)"(?:\u8868|\u82e5\u4f9d)", (String)"");
    }

    public static String getDbType(String columnType) {
        if (StringHelper.indexOf((CharSequence)columnType, (CharSequence)"(") > 0) {
            return StringHelper.substringBefore((String)columnType, (String)"(");
        }
        return columnType;
    }

    public static Integer getColumnLength(String columnType) {
        if (StringHelper.indexOf((CharSequence)columnType, (CharSequence)"(") > 0) {
            String length = StringHelper.substringBetween((String)columnType, (String)"(", (String)")");
            return Integer.valueOf(length);
        }
        return 0;
    }
}

