package com.testor.common.constant;

import com.tongtech.tfw.backend.common.models.response.ResponseInfo;

/**
 * @ClassName: IamErrorEnum
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2024/1/4 19:04
 * @Version: 1.0
 */
public enum IamErrorEnum {

    CALL_IAM_FAILED(2000, "调用IAM服务失败"),
    EXCHANGE_FAILED(2001, "code交换用户信息失败"),
    VALIDATION_FAILED(2002,"id_token验证失败");

    private final int code;
    private final String msg;

    private IamErrorEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }

    public ResponseInfo transform() {
        return ResponseInfo.builder().code(this.code()).msg(this.msg()).build();
    }
}
