package com.testor.ddd.safetyControl.application.service.riskLeclsManage.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.application.service.riskLeclsManage.RiskLeclsManageService;
import com.testor.ddd.safetyControl.domain.lecls.entity.TSafeRiskLeclsConfRepo;
import com.testor.ddd.safetyControl.domain.lecls.entity.TSafeRiskLeclsRelationRepo;
import com.testor.ddd.safetyControl.domain.lecls.entity.TSafeRiskRealLevelRelationRepo;
import com.testor.ddd.safetyControl.domain.lecls.service.RiskLeclsService;
import com.testor.ddd.safetyControl.interfaces.model.dto.lecls.*;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RiskLeclsManageServiceImpl implements RiskLeclsManageService {

    @Resource
    private RiskLeclsService riskLeclsService;

    @Resource
    private TSafeRiskLeclsConfRepo tSafeRiskLeclsConfRepo;
    
    @Resource
    private TSafeRiskLeclsRelationRepo tSafeRiskLeclsRelationRepo;

    @Resource
    private TSafeRiskRealLevelRelationRepo tSafeRiskRealLevelRelationRepo;

    /**
     * 编辑空间
     *
     * @param riskLeclsConfDtoList
     * @return
     */
    @Transactional
    public BaseResponse<List<TSafeRiskLeclsConfDTO>> editRiskLeclsConf(List<TSafeRiskLeclsConfDTO> riskLeclsConfDtoList) throws RuntimeException {
        BaseResponse<List<TSafeRiskLeclsConfDTO>> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        if(riskLeclsConfDtoList == null || riskLeclsConfDtoList.size() == 0) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("参数缺失");
            return baseResponse;
        }

        baseResponse = riskLeclsService.editRiskLeclsConf(curUser.getUserId(), riskLeclsConfDtoList);
        if(baseResponse.getCode() != 200) {
           // baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        return baseResponse;
    }

    public TSafeRiskLeclsConfDTO findById(String id){
        return tSafeRiskLeclsConfRepo.findById(id);
    }

    @Transactional
    public BaseResponse deleteById(String id) throws BusinessException {
        BaseResponse baseResponse = new BaseResponse<>();
        tSafeRiskLeclsConfRepo.deleteById(id);
        return baseResponse;
    }

    public List<TSafeRiskLeclsConfDTO> listAllEntity(TSafeRiskLeclsConfDTOParam param){
        return tSafeRiskLeclsConfRepo.listAllEntity(param);
    }



    /**
     * 编辑空间
     *
     * @param riskLeclsRelationDtoList
     * @return
     */
    @Transactional
    public BaseResponse<List<TSafeRiskLeclsRelationDTO>> editRiskLeclsRelation(List<TSafeRiskLeclsRelationDTO> riskLeclsRelationDtoList) throws RuntimeException {
        BaseResponse<List<TSafeRiskLeclsRelationDTO>> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        if(riskLeclsRelationDtoList == null || riskLeclsRelationDtoList.size() == 0) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("参数缺失");
            return baseResponse;
        }

        baseResponse = riskLeclsService.editRiskLeclsRelation(curUser.getUserId(), riskLeclsRelationDtoList);
        if(baseResponse.getCode() != 200) {
            // baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        return baseResponse;
    }

    public TSafeRiskLeclsRelationDTO findRelationById(String id){
        return tSafeRiskLeclsRelationRepo.findById(id);
    }

    @Transactional
    public BaseResponse deleteRelationById(String id) throws BusinessException {
        BaseResponse baseResponse = new BaseResponse<>();
        tSafeRiskLeclsRelationRepo.deleteById(id);
        return baseResponse;
    }

    public List<TSafeRiskLeclsRelationDTO> listRelationAllEntity(TSafeRiskLeclsRelationDTOParam param){
        return tSafeRiskLeclsRelationRepo.listAllEntity(param);
    }

    public BaseResponse deleteRelationByType(Integer type) {
        BaseResponse baseResponse = new BaseResponse<>();
        boolean result = tSafeRiskLeclsRelationRepo.deleteRelationByType(type);
        if(result) {
            return baseResponse;
        }
        baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
        baseResponse.setMsg("删除失败");
        return baseResponse;
    }


    /**
     * 根据 lec/ls 计算 现实风险等级
     * @param leclsValDTO
     */
    public TSafeRiskRealLevelRelationDTO findLevelByLecls(RiskLeclsValDTO leclsValDTO) throws BusinessException{

        int type = leclsValDTO.getType();
        float value = 0;
        if(type == 1) {// lec
            value = leclsValDTO.getLecL() * leclsValDTO.getLecC() * leclsValDTO.getLecE();
        } else if( type == 2) {// ls
            value = leclsValDTO.getLsL() * leclsValDTO.getLsS();
        } else {
            return null;
        }

        leclsValDTO.setValue(value);
        TSafeRiskLeclsRelationDTO leclsRelationDTO = tSafeRiskLeclsRelationRepo.findLevelByLecls(leclsValDTO);
        if(leclsRelationDTO == null) {
            return null;
        }
        String levelId = leclsRelationDTO.getRealLevel();
        List<TSafeRiskRealLevelRelationDTO> levelRelationDTOList = tSafeRiskRealLevelRelationRepo.findByRealLevel(levelId);
        if(levelRelationDTOList == null || levelRelationDTOList.size() != 1) {
            throw new BusinessException("危险等级关联管控信息错误，请先确认功能配置模块--设置范围");
        }
        return levelRelationDTOList.get(0);
    }
}
