package com.testor.ddd.safetyControl.infrastructure.repository.riskSource.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.riskSource.entity.TSafeRiskSourceRecordRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskSource.dao.TSafeRiskSourceRecordDao;
import com.testor.ddd.safetyControl.infrastructure.repository.riskSource.entity.TSafeRiskSourceRecordDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceRecordDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceRecordDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceRecordVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class TSafeRiskSourceRecordServiceImpl extends SuperServiceImpl<TSafeRiskSourceRecordDao, TSafeRiskSourceRecordDO>
        implements TSafeRiskSourceRecordRepo // ,TSafeRiskSourceRecordService

{
    @Autowired(required = false)
    private TSafeRiskSourceRecordDao tSafeRiskSourceRecordDao;

    public TSafeRiskSourceRecordDTO insert(TSafeRiskSourceRecordDTO riskSourceRecordDTO){
        TSafeRiskSourceRecordDO data = BeanHelper.beanToBean(riskSourceRecordDTO, TSafeRiskSourceRecordDO.class);
        int result = tSafeRiskSourceRecordDao.insert(data);
        if(result < 1) {
            return null;
        }
        riskSourceRecordDTO = BeanHelper.beanToBean(data, TSafeRiskSourceRecordDTO.class);
        return riskSourceRecordDTO;
    }

    /**
     * 分页查询
     * @param param
     * @return
     */
    @Override
    public BaseResponseList<TSafeRiskSourceRecordVO> listPage(TSafeRiskSourceRecordDTOParam param){
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeRiskSourceRecordVO> resultPage = new Page<>(page, limit);
        IPage<TSafeRiskSourceRecordVO> iPage = tSafeRiskSourceRecordDao.listPage(resultPage, param);

        BaseResponseList<TSafeRiskSourceRecordVO> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }
}

