package com.testor.ddd.safetyControl.interfaces.model.vo.riskStatistics;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 危险点(风险分级)对象 t_safe_risk_point
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:14
 */
@Data
public class RiskStatisticsNumVO implements Serializable
{

//  /**
//   * 组织机构id
//   */
//  @ApiModelProperty(value = "组织机构id")
//  private String orgId;
//
//  @ApiModelProperty(value = "组织机构")
//  private String orgName;

  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "横坐标数据id")
  private String coordinateId;

  @ApiModelProperty(value = "横坐标数据名称")
  private String coordinateName;

//  @ApiModelProperty(value = "风险类型")
//  private String typeName;

  @ApiModelProperty(value = "风险等级key")
  private String riskLevelKey;

  @ApiModelProperty(value = "风险等级名称")
  private String riskLevelValue;

  @ApiModelProperty(value = "现实风险等级(关联字典表id)")
  private String riskLevelId;

  @ApiModelProperty(value = "数量")
  private String num;

  @ApiModelProperty(value = "层次级别，1顶级依次类推")
  private BigDecimal treeLevel;

  @ApiModelProperty(value = "企业性质（字典类型：NATURE）")
  private String nature;
}
