package com.testor.module.ZLOA.sysUserOA.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.ZLOA.sysUserOA.model.domain.TSysUserOa;
import com.testor.module.ZLOA.sysUserOA.model.dto.TSysUserOaDelParam;
import com.testor.module.ZLOA.sysUserOA.model.dto.TSysUserOaParam;
import com.testor.module.ZLOA.sysUserOA.service.TSysUserOaService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 用户 (OA)Controller
 *
 * @author testor-framework
 * @date 2022-09-29 15:49:08
 */
@RestController
//@RequestMapping("/module/oa")
//@Api(value = "TSysUserOa", tags = "用户 (OA)")
@Slf4j
public class TSysUserOaController extends SuperController
{
    @Autowired
    private TSysUserOaService tSysUserOaService;

    /* Generated Method*/
	@ApiOperation(value = "新增 用户 (OA)", notes = "Add TSysUserOa")
	@PostMapping(value = "/add")
	public BaseResponse<TSysUserOa>addEntity(@RequestBody TSysUserOa addRequest) {
		BaseResponse<TSysUserOa> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TSysUserOa data=BeanHelper.beanToBean(addRequest,  TSysUserOa.class);
			data.setId(id);
			boolean result= tSysUserOaService.save(data);
			if(result){
                TSysUserOa newEntity = new TSysUserOa();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 用户 (OA) ", notes = "Get TSysUserOa By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSysUserOa> getById(String userId){
		BaseResponse<TSysUserOa> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(userId)){
			// TODO 按需求添加业务异常判断
            TSysUserOa data= tSysUserOaService.getById(userId);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 用户 (OA) ", notes = "Update TSysUserOa By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSysUserOa updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysUserOa data=BeanHelper.beanToBean(updateRequest, TSysUserOa.class);
			boolean result= tSysUserOaService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 用户 (OA) ", notes = "delete TSysUserOa By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSysUserOaDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysUserOa data= new TSysUserOa();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSysUserOaService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除用户 (OA)", notes = "delete TSysUserOa by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSysUserOaDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSysUserOa> tSysUserOaList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSysUserOa data= new TSysUserOa();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSysUserOaList.add(data);
			}
			boolean result = tSysUserOaService.updateBatchById(tSysUserOaList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 用户 (OA) 分页列表", notes = "List TSysUserOa with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSysUserOa>>listEntity(TSysUserOaParam param){
		BaseResponse<BaseResponseList<TSysUserOa>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TSysUserOa> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSysUserOa> queryWrapper=this.createQuery(param);
		Page<TSysUserOa> resultList= tSysUserOaService.page(resultPage,queryWrapper);
		BaseResponseList<TSysUserOa> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 用户 (OA) 列表", notes = "List TSysUserOa all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSysUserOa>>listAllEntity(TSysUserOaParam param){
		BaseResponse<BaseResponseList<TSysUserOa>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSysUserOa> queryWrapper=this.createQuery(param);
		List<TSysUserOa> resultList=tSysUserOaService.list(queryWrapper);
		BaseResponseList<TSysUserOa> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSysUserOa> createQuery(TSysUserOaParam queryParam){
		QueryWrapper<TSysUserOa> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getOrgId())){
			queryWrapper.eq(TSysUserOa.ORG_ID,queryParam.getOrgId());
		}
		if(StringHelper.isNotEmpty(queryParam.getLoginName())){
			queryWrapper.like(TSysUserOa.LOGIN_NAME,queryParam.getLoginName());
		}
		if(StringHelper.isNotEmpty(queryParam.getLoginPwd())){
			queryWrapper.eq(TSysUserOa.LOGIN_PWD,queryParam.getLoginPwd());
		}
		if(StringHelper.isNotEmpty(queryParam.getUserName())){
			queryWrapper.like(TSysUserOa.USER_NAME,queryParam.getUserName());
		}
		if(StringHelper.isNotEmpty(queryParam.getUserType())){
			queryWrapper.eq(TSysUserOa.USER_TYPE,queryParam.getUserType());
		}
		if(StringHelper.isNotEmpty(queryParam.getPhotoUrl())){
			queryWrapper.eq(TSysUserOa.PHOTO_URL,queryParam.getPhotoUrl());
		}
		if(StringHelper.isNotEmpty(queryParam.getLoginIp())){
			queryWrapper.eq(TSysUserOa.LOGIN_IP,queryParam.getLoginIp());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getLoginDate())){
			queryWrapper.eq(TSysUserOa.LOGIN_DATE,queryParam.getLoginDate());
		}
		if(StringHelper.isNotEmpty(queryParam.getPwdSecurityLevel())){
			queryWrapper.eq(TSysUserOa.PWD_SECURITY_LEVEL,queryParam.getPwdSecurityLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getSex())){
			queryWrapper.eq(TSysUserOa.SEX,queryParam.getSex());
		}
		if(StringHelper.isNotEmpty(queryParam.getAddress())){
			queryWrapper.eq(TSysUserOa.ADDRESS,queryParam.getAddress());
		}
		if(StringHelper.isNotEmpty(queryParam.getZipCode())){
			queryWrapper.eq(TSysUserOa.ZIP_CODE,queryParam.getZipCode());
		}
		if(StringHelper.isNotEmpty(queryParam.getPhoneNo())){
			queryWrapper.eq(TSysUserOa.PHONE_NO,queryParam.getPhoneNo());
		}
		if(StringHelper.isNotEmpty(queryParam.getFax())){
			queryWrapper.eq(TSysUserOa.FAX,queryParam.getFax());
		}
		if(StringHelper.isNotEmpty(queryParam.getEmail())){
			queryWrapper.eq(TSysUserOa.EMAIL,queryParam.getEmail());
		}
		if(StringHelper.isNotEmpty(queryParam.getUserKeyPid())){
			queryWrapper.eq(TSysUserOa.USER_KEY_PID,queryParam.getUserKeyPid());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getAge())){
			queryWrapper.eq(TSysUserOa.AGE,queryParam.getAge());
		}
		if(StringHelper.isNotEmpty(queryParam.getDeptId())){
			queryWrapper.eq(TSysUserOa.DEPT_ID,queryParam.getDeptId());
		}
		if(StringHelper.isNotEmpty(queryParam.getPostId())){
			queryWrapper.eq(TSysUserOa.POST_ID,queryParam.getPostId());
		}
		if(StringHelper.isNotEmpty(queryParam.getOrgName())){
			queryWrapper.like(TSysUserOa.ORG_NAME,queryParam.getOrgName());
		}
		if(StringHelper.isNotEmpty(queryParam.getPostName())){
			queryWrapper.like(TSysUserOa.POST_NAME,queryParam.getPostName());
		}
		if(StringHelper.isNotEmpty(queryParam.getDeputyPostId())){
			queryWrapper.eq(TSysUserOa.DEPUTY_POST_ID,queryParam.getDeputyPostId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSysUserOa.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSysUserOa.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSysUserOa.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
