package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorSafetyBriefDetail;
import com.testor.module.contractor.manage.model.dto.TContractorSafetyBriefDetailParam;
import com.testor.module.contractor.manage.model.dto.TContractorSafetyBriefDetailDelParam;
import com.testor.module.contractor.manage.service.TContractorSafetyBriefDetailService;

/**
 * 承包商管理-安全交底-交底内容Controller
 *
 * @author testor-framework
 * @date 2024-11-28 11:38:01
 */
@RestController
@RequestMapping("/contractorManage/briefDetail")
@Api(value = "TContractorSafetyBriefDetail", tags = "承包商管理-安全交底-交底内容")
@Slf4j
public class TContractorSafetyBriefDetailController extends SuperController
{
    @Autowired
    private TContractorSafetyBriefDetailService tContractorSafetyBriefDetailService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商管理-安全交底-交底内容", notes = "Add TContractorSafetyBriefDetail")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorSafetyBriefDetail>addEntity(@RequestBody TContractorSafetyBriefDetail addRequest) {
		BaseResponse<TContractorSafetyBriefDetail> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorSafetyBriefDetail data=BeanHelper.beanToBean(addRequest,  TContractorSafetyBriefDetail.class);
			data.setId(id);
			boolean result= tContractorSafetyBriefDetailService.save(data);
			if(result){
                TContractorSafetyBriefDetail newEntity = new TContractorSafetyBriefDetail();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-安全交底-交底内容 ", notes = "Get TContractorSafetyBriefDetail By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorSafetyBriefDetail> getById(String id){
		BaseResponse<TContractorSafetyBriefDetail> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorSafetyBriefDetail data= tContractorSafetyBriefDetailService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商管理-安全交底-交底内容 ", notes = "Update TContractorSafetyBriefDetail By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorSafetyBriefDetail updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorSafetyBriefDetail data=BeanHelper.beanToBean(updateRequest, TContractorSafetyBriefDetail.class);
			boolean result= tContractorSafetyBriefDetailService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商管理-安全交底-交底内容 ", notes = "delete TContractorSafetyBriefDetail By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorSafetyBriefDetailDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorSafetyBriefDetail data= new TContractorSafetyBriefDetail();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorSafetyBriefDetailService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商管理-安全交底-交底内容", notes = "delete TContractorSafetyBriefDetail by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorSafetyBriefDetailDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorSafetyBriefDetail> tContractorSafetyBriefDetailList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorSafetyBriefDetail data= new TContractorSafetyBriefDetail();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorSafetyBriefDetailList.add(data);
			}
			boolean result = tContractorSafetyBriefDetailService.updateBatchById(tContractorSafetyBriefDetailList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-安全交底-交底内容 分页列表", notes = "List TContractorSafetyBriefDetail with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorSafetyBriefDetail>>listEntity(TContractorSafetyBriefDetailParam param){
		BaseResponse<BaseResponseList<TContractorSafetyBriefDetail>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorSafetyBriefDetail> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorSafetyBriefDetail> queryWrapper=this.createQuery(param);
		Page<TContractorSafetyBriefDetail> resultList= tContractorSafetyBriefDetailService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorSafetyBriefDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-安全交底-交底内容 列表", notes = "List TContractorSafetyBriefDetail all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorSafetyBriefDetail>>listAllEntity(TContractorSafetyBriefDetailParam param){
		BaseResponse<BaseResponseList<TContractorSafetyBriefDetail>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorSafetyBriefDetail> queryWrapper=this.createQuery(param);
		List<TContractorSafetyBriefDetail> resultList=tContractorSafetyBriefDetailService.list(queryWrapper);
		BaseResponseList<TContractorSafetyBriefDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorSafetyBriefDetail> createQuery(TContractorSafetyBriefDetailParam queryParam){
		QueryWrapper<TContractorSafetyBriefDetail> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getBriefId())){
			queryWrapper.eq(TContractorSafetyBriefDetail.BRIEF_ID,queryParam.getBriefId());
		}
		if(StringHelper.isNotEmpty(queryParam.getContractorId())){
			queryWrapper.eq(TContractorSafetyBriefDetail.CONTRACTOR_ID,queryParam.getContractorId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProjId())){
			queryWrapper.eq(TContractorSafetyBriefDetail.PROJ_ID,queryParam.getProjId());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizId())){
			queryWrapper.eq(TContractorSafetyBriefDetail.BIZ_ID,queryParam.getBizId());
		}
		if(StringHelper.isNotEmpty(queryParam.getContent())){
			queryWrapper.eq(TContractorSafetyBriefDetail.CONTENT,queryParam.getContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getOtherContent())){
			queryWrapper.eq(TContractorSafetyBriefDetail.OTHER_CONTENT,queryParam.getOtherContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getCode())){
			queryWrapper.eq(TContractorSafetyBriefDetail.CODE,queryParam.getCode());
		}
		if(StringHelper.isNotEmpty(queryParam.getBriefStatus())){
			queryWrapper.eq(TContractorSafetyBriefDetail.BRIEF_STATUS,queryParam.getBriefStatus());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getTreeSort())){
			queryWrapper.eq(TContractorSafetyBriefDetail.TREE_SORT,queryParam.getTreeSort());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorSafetyBriefDetail.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorSafetyBriefDetail.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorSafetyBriefDetail.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
