package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.manage.dao.TContractorDailyPlanContentDao;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlan;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanContent;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanContentParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanContentService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 日常管理-每日工作计划-工作内容Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-28 15:40:20
 */
@Service
public class TContractorDailyPlanContentServiceImpl extends SuperServiceImpl<TContractorDailyPlanContentDao, TContractorDailyPlanContent> implements TContractorDailyPlanContentService
{
    @Autowired(required = false)
    private TContractorDailyPlanContentDao tContractorDailyPlanContentDao;

    @Override
    public List<TContractorDailyPlanContent> getByIdAndType(String id, String type) {
        TContractorDailyPlanContentParam tContractorDailyPlanContentParam = new TContractorDailyPlanContentParam();
        tContractorDailyPlanContentParam.setPlanId(id);
        tContractorDailyPlanContentParam.setType(type);
        return listAllEntity(tContractorDailyPlanContentParam);
    }

    @Override
    public Page<TContractorDailyPlanContent> listEntity(TContractorDailyPlanContentParam param) {
        Long page=
                StringHelper.isEmpty(param.getPage())? BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TContractorDailyPlanContent> resultPage=new Page<>(page,limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TContractorDailyPlanContent> queryWrapper=this.createQuery(param);
        return this.page(resultPage,queryWrapper);
    }

    @Override
    public List<TContractorDailyPlanContent> listAllEntity(TContractorDailyPlanContentParam param) {
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TContractorDailyPlanContent> queryWrapper=this.createQuery(param);
        return this.list(queryWrapper);
    }

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorDailyPlanContent> createQuery(TContractorDailyPlanContentParam queryParam){
        QueryWrapper<TContractorDailyPlanContent> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getPlanId())){
            queryWrapper.eq(TContractorDailyPlanContent.PLAN_ID,queryParam.getPlanId());
        }
        if(StringHelper.isNotEmpty(queryParam.getType())){
            queryWrapper.eq(TContractorDailyPlanContent.TYPE,queryParam.getType());
        }
        if(StringHelper.isNotEmpty(queryParam.getWorkContent())){
            queryWrapper.eq(TContractorDailyPlanContent.WORK_CONTENT,queryParam.getWorkContent());
        }
        if(StringHelper.isNotEmpty(queryParam.getIfInvolve())){
            queryWrapper.eq(TContractorDailyPlanContent.IF_INVOLVE,queryParam.getIfInvolve());
        }
        if(StringHelper.isNotEmpty(queryParam.getContent())){
            queryWrapper.eq(TContractorDailyPlanContent.CONTENT,queryParam.getContent());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getSortNo())){
            queryWrapper.eq(TContractorDailyPlanContent.SORT_NO,queryParam.getSortNo());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorDailyPlanContent.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorDailyPlanContent.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorDailyPlanContent.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
