package com.testor.module.duty.controller;

import java.util.ArrayList;
import java.util.List;

import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.duty.model.domain.TSysSelective;
import com.testor.module.duty.model.dto.TSysSelectiveDelParam;
import com.testor.module.duty.model.dto.TSysSelectiveParam;
import com.testor.module.duty.service.TSysSelectiveService;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.TypeHelper;


/**
 * 值班抽查Controller
 *
 * @author testor-framework
 * @date 2022-06-06 10:06:20
 */
@RestController
@RequestMapping("/selective")
@Api(value = "TSysSelective", tags = "值班抽查")
@Slf4j
public class TSysSelectiveController extends SuperController {
    @Autowired
    private TSysSelectiveService tSysSelectiveService;
    @Autowired
    private SysOrgService sysOrgService;

    /* Generated Method*/
    @ApiOperation(value = "新增 值班抽查", notes = "Add TSysSelective")
    @PostMapping(value = "/add")
    public BaseResponse<TSysSelective> addEntity(@RequestBody TSysSelective addRequest) throws Exception {
        return tSysSelectiveService.add(addRequest);
    }

    @ApiOperation(value = "获取 值班抽查 ", notes = "Get TSysSelective By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TSysSelective> getByIds(String id) {
        return tSysSelectiveService.getByIds(id);
    }

    @ApiOperation(value = "修改 值班抽查 ", notes = "Update TSysSelective By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSysSelective updateRequest) {
        return tSysSelectiveService.updateEntity(updateRequest);
    }

    @ApiOperation(value = "删除 值班抽查 ", notes = "delete TSysSelective By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSysSelectiveDelParam deleteRequest) {
        return tSysSelectiveService.deleteEntity(deleteRequest);
    }

    //	@ApiOperation(value = "批量删除值班抽查", notes = "delete TSysSelective by batch Id")
//	@PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TSysSelectiveDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TSysSelective> tSysSelectiveList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TSysSelective data = new TSysSelective();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tSysSelectiveList.add(data);
            }
            boolean result = tSysSelectiveService.updateBatchById(tSysSelectiveList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 值班抽查 分页列表", notes = "List TSysSelective with page")
    @PostMapping(value = "/list")
    public BaseResponse<BaseResponseList<TSysSelective>> listEntity(@RequestBody TSysSelectiveParam param) {
        BaseResponse<BaseResponseList<TSysSelective>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSysSelective> resultPage = new Page<>(page, limit);
        QueryWrapper<TSysSelective> queryWrapper = this.createQuery(param);
        Page<TSysSelective> resultList = tSysSelectiveService.page(resultPage, queryWrapper);
        BaseResponseList<TSysSelective> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    //	@ApiOperation(value = "获取 值班抽查 列表", notes = "List TSysSelective all")
//	@GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TSysSelective>> listAllEntity(TSysSelectiveParam param) {
        BaseResponse<BaseResponseList<TSysSelective>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TSysSelective> queryWrapper = this.createQuery(param);
        List<TSysSelective> resultList = tSysSelectiveService.list(queryWrapper);
        BaseResponseList<TSysSelective> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSysSelective> createQuery(TSysSelectiveParam queryParam) {
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        QueryWrapper<TSysSelective> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByDesc(TSysSelective.IS_ISSUE,TSysSelective.CHECK_TIME);
        if (StringHelper.isNotEmpty(queryParam.getCompanyId())) {
            String[] split = queryParam.getCompanyId().split(",");
            queryWrapper.in(TSysSelective.ORG_ID, split);
        }else{
            queryWrapper.eq(TSysSelective.COMPANY_ID, sysOrg.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStartDate()) && StringHelper.isNotEmpty(queryParam.getEndDate())) {
            queryWrapper.between(TSysSelective.DUTY_DATE, queryParam.getStartDate(), queryParam.getEndDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getIsIssue())) {
            queryWrapper.eq(TSysSelective.IS_ISSUE, queryParam.getIsIssue());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TSysSelective.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TSysSelective.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TSysSelective.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getSelectivePerson())) {
            queryWrapper.eq(TSysSelective.SELECTIVE_PERSON, queryParam.getSelectivePerson());
        }
        if (StringHelper.isNotEmpty(queryParam.getDeptName())) {
            queryWrapper.like(TSysSelective.DEPT_NAME, queryParam.getDeptName());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getCheckTime())) {
            queryWrapper.eq(TSysSelective.CHECK_TIME, queryParam.getCheckTime());
        }
        if (StringHelper.isNotEmpty(queryParam.getWorkCase())) {
            queryWrapper.eq(TSysSelective.WORK_CASE, queryParam.getWorkCase());
        }
        if (StringHelper.isNotEmpty(queryParam.getExistIssue())) {
            queryWrapper.eq(TSysSelective.EXIST_ISSUE, queryParam.getExistIssue());
        }
        if (StringHelper.isNotEmpty(queryParam.getPattern())) {
            queryWrapper.eq(TSysSelective.PATTERN, queryParam.getPattern());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckPersonPhoto())) {
            queryWrapper.eq(TSysSelective.CHECK_PERSON_PHOTO, queryParam.getCheckPersonPhoto());
        }
        if (StringHelper.isNotEmpty(queryParam.getIssuePhoto())) {
            queryWrapper.eq(TSysSelective.ISSUE_PHOTO, queryParam.getIssuePhoto());
        }
        if (StringHelper.isNotEmpty(queryParam.getDutyOperator())) {
            queryWrapper.eq(TSysSelective.DUTY_OPERATOR, queryParam.getDutyOperator());
        }
        if (StringHelper.isNotEmpty(queryParam.getDutyOperatorId())) {
            queryWrapper.eq(TSysSelective.DUTY_OPERATOR_ID, queryParam.getDutyOperatorId());
        }
        if (StringHelper.isNotEmpty(queryParam.getUnitBelong())) {
            queryWrapper.eq(TSysSelective.UNIT_BELONG, queryParam.getUnitBelong());
        }
        if (StringHelper.isNotEmpty(queryParam.getCompanyName())) {
            queryWrapper.like(TSysSelective.COMPANY_NAME, queryParam.getCompanyName());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantName())) {
            queryWrapper.like(TSysSelective.TENANT_NAME, queryParam.getTenantName());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSysSelective.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSysSelective.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TSysSelective.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
