package com.testor.module.environment.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.biz.sys.dict.data.controller.SysDictDataController;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataResponse;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.model.dto.ReturnOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.module.accident.model.resp.ReportUnitResp;
import com.testor.module.environment.model.domain.TBasicEnvironmentManage;
import com.testor.module.environment.model.dto.TBasicEnvironmentManageDelParam;
import com.testor.module.environment.model.dto.TBasicEnvironmentManageParam;
import com.testor.module.environment.service.TBasicEnvironmentManageService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 环保基本面管理Controller
 *
 * @author testor-framework
 * @date 2022-09-16 13:37:50
 */
@RestController
@RequestMapping("/module/manage")
@Api(value = "TBasicEnvironmentManage", tags = "环保基本面管理")
@Slf4j
public class TBasicEnvironmentManageController extends SuperController {
    @Autowired
    private TBasicEnvironmentManageService tBasicEnvironmentManageService;

    @Autowired
    private SysOrgService sysOrgService;

    @Autowired
    private SysUserService sysUserService;

    @Autowired
    private SysDictDataController sysDictDataController;

    /* Generated Method*/
    @ApiOperation(value = "编辑 环保基本面管理", notes = "Add TBasicEnvironmentManage")
    @PostMapping(value = "/edit")
    public BaseResponse<TBasicEnvironmentManage> edit(@RequestBody TBasicEnvironmentManage addRequest) {
        return tBasicEnvironmentManageService.edit(addRequest);
    }

    @ApiOperation(value = "查看 环保基本面管理 ", notes = "Get TBasicEnvironmentManage By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TBasicEnvironmentManage> getById(String orgId) {
        return tBasicEnvironmentManageService.getByIds(orgId);
    }

    @ApiModelProperty(value = "根据机构id获取机构路径")
    @GetMapping(value = "/lookOrg")
    public BaseResponse<ReportUnitResp> lookOrg(String orgId) throws Exception {
        BaseResponse<ReportUnitResp> baseResponse = new BaseResponse<>();
        baseResponse.setData(tBasicEnvironmentManageService.lookOrg(orgId));
        return baseResponse;
    }

    @ApiOperation(value = "父级人员", notes = "")
    @GetMapping(value = "/returnParentPerson")
    public BaseResponse<ReturnOrg> returnDeptPerson() {
        BaseResponse<ReturnOrg> baseResponse = new BaseResponse<>();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        SysOrg sysOrg = sysOrgService.getById(orgId);

        // 企业信息
        SysOrg one = sysOrgService.getOne(new QueryWrapper<SysOrg>()
//                .eq(SysOrg.ORG_ID, sysOrg.getParentId())
                        .eq(SysOrg.ORG_ID, sysOrg.getParentId())
                        .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE)
        );
        ReturnOrg returnOrg  = new ReturnOrg();
        if(one == null){
            returnOrg = BeanHelper.beanToBean(sysOrg, ReturnOrg.class);
        }else {
            returnOrg = BeanHelper.beanToBean(one, ReturnOrg.class);
        }

        // 企业下面的部门信息
        List<SysOrg> list = sysOrgService.list(new QueryWrapper<SysOrg>()
                .eq(SysOrg.PARENT_ID, returnOrg.getOrgId())
                .eq(SysOrg.IS_DEPT, "1")
                .ne(SysOrg.STATUS, BizConstants.STATUS_DELETE)
        );
        // 每一个部门下面的人员
        ArrayList<SysOrg> returnOrgs = new ArrayList<>();
        for (SysOrg org : list) {
            ReturnOrg returnOrg1 = BeanHelper.beanToBean(org, ReturnOrg.class);
            List<SysUser> list1 = sysUserService.list(new QueryWrapper<SysUser>()
                    .eq(SysUser.DEPT_ID, returnOrg1.getOrgId())
                    .ne(SysUser.STATUS, BizConstants.STATUS_DELETE)
            );
            returnOrg1.setUsers(list1);
            returnOrgs.add(returnOrg1);
        }
        returnOrg.setOrgList(returnOrgs);
        baseResponse.setData(returnOrg);
        return baseResponse;
    }


    @ApiOperation(value = "获取 环保基本面管理 分页列表", notes = "List TBasicEnvironmentManage with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TBasicEnvironmentManage>> listEntity(TBasicEnvironmentManageParam param) {
        BaseResponse<BaseResponseList<TBasicEnvironmentManage>> baseResponse = new BaseResponse<>();

        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        String parentIds = sysOrg.getParentIds();
        String orgId = sysOrg.getOrgId();
        List<String> companyIds = param.getCompanyIds();
        IPage<TBasicEnvironmentManage> resultList = tBasicEnvironmentManageService.getList(param, parentIds, orgId, companyIds);
        BaseResponseList<TBasicEnvironmentManage> baseResponseList = new BaseResponseList<>();
        List<TBasicEnvironmentManage> tBasicEnvironmentManages = converDict(resultList.getRecords());
        tBasicEnvironmentManages.forEach(
                item -> {
                    item.setLocation(StringUtils.isNotBlank(item.getLocation()) ? item.getLocation() : "-");
                    item.setTroubleshoot(StringUtils.isNotBlank(item.getTroubleshoot()) ? item.getTroubleshoot() : "-");
                    item.setSensitiveAreas(StringUtils.isNotBlank(item.getSensitiveAreas()) ? item.getSensitiveAreas() : "-");
                    item.setCheckCase(StringUtils.isNotBlank(item.getCheckCase()) ? item.getCheckCase() : "-");
                    item.setLicence(StringUtils.isNotBlank(item.getLicence()) ? item.getLicence() : "-");
                    item.setPollution(StringUtils.isNotBlank(item.getPollution()) ? item.getPollution() : "-");
                    item.setRiskPoint(StringUtils.isNotBlank(item.getRiskPoint()) ? item.getRiskPoint() : "-");
                    item.setIntake(StringUtils.isNotBlank(item.getIntake()) ? item.getIntake() : "-");
                    item.setDrain(StringUtils.isNotBlank(item.getDrain()) ? item.getDrain() : "-");
                    item.setDust(StringUtils.isNotBlank(item.getDust()) ? item.getDust() : "-");
                    item.setSo2(StringUtils.isNotBlank(item.getSo2()) ? item.getSo2() : "-");
                    item.setNox(StringUtils.isNotBlank(item.getNox()) ? item.getNox() : "-");
                    item.setVocs(StringUtils.isNotBlank(item.getVocs()) ? item.getVocs() : "-");
                    item.setFlueCount(StringUtils.isNotBlank(item.getFlueCount()) ? item.getFlueCount() : "-");
                    item.setFlueDeal(StringUtils.isNotBlank(item.getFlueDeal()) ? item.getFlueDeal() : "-");
                    item.setFlueDeal(StringUtils.isNotBlank(item.getFlueDeal()) ? item.getFlueDeal() : "-");
                    item.setCodcr(StringUtils.isNotBlank(item.getCodcr()) ? item.getCodcr() : "-");
                    item.setNh3N(StringUtils.isNotBlank(item.getNh3N()) ? item.getNh3N() : "-");
                    item.setWasteCount(StringUtils.isNotBlank(item.getWasteCount()) ? item.getWasteCount() : "-");
                    item.setWasteDeal(StringUtils.isNotBlank(item.getWasteDeal()) ? item.getWasteDeal() : "-");
                    item.setBoilerStage(StringUtils.isNotBlank(item.getBoilerStage()) ? item.getBoilerStage() : "-");
                    item.setBoilerTon(StringUtils.isNotBlank(item.getBoilerTon()) ? item.getBoilerTon() : "-");
                    item.setThenStatus(StringUtils.isNotBlank(item.getThenStatus()) ? item.getThenStatus() : "-");
                    item.setBiologyStage(StringUtils.isNotBlank(item.getBiologyStage()) ? item.getBiologyStage() : "-");
                    item.setBiologyTon(StringUtils.isNotBlank(item.getBiologyTon()) ? item.getBiologyTon() : "-");
                    item.setFuelStage(StringUtils.isNotBlank(item.getFuelStage()) ? item.getFuelStage() : "-");
                    item.setFuelTon(StringUtils.isNotBlank(item.getFuelTon()) ? item.getFuelTon() : "-");
                    item.setFuelTon(StringUtils.isNotBlank(item.getFuelTon()) ? item.getFuelTon() : "-");
                }
        );
        baseResponseList.setData(tBasicEnvironmentManages);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "导出 环保基本面管理")
    @GetMapping(value = "/export")
    public BaseResponse export(TBasicEnvironmentManageParam param, HttpServletResponse response) {
        BaseResponse baseResponse = new BaseResponse<>();
        tBasicEnvironmentManageService.export(response, param);
        return baseResponse;
    }


    /**
     * 转字典值
     *
     * @param baseResponseList
     * @return
     */
    private List<TBasicEnvironmentManage> converDict(List<TBasicEnvironmentManage> baseResponseList) {
        List<TBasicEnvironmentManage> data1 = new ArrayList<>();
        for (TBasicEnvironmentManage datum : baseResponseList) {
            TBasicEnvironmentManage tTrainDatabase = BeanHelper.beanToBean(datum, TBasicEnvironmentManage.class);
            String oneMaterialsType = tTrainDatabase.getIntake();
            // 取水方式
            SysDictDataResponse materials2 = sysDictDataController.getDictTypeDetail("", "INTAKE_WAY", oneMaterialsType).getData();
            if (ObjectHelper.isNotEmpty(materials2)) {
                String materials = materials2.getDictValue();
                tTrainDatabase.setIntake(materials);
            }
            // 排水方式
            String senMaterialsType = tTrainDatabase.getDrain();
            SysDictDataResponse materials3 = sysDictDataController.getDictTypeDetail("", "DRAIN_WAY", senMaterialsType).getData();
            if (ObjectHelper.isNotEmpty(materials3)) {
                String materials1 = materials3.getDictValue();
                tTrainDatabase.setDrain(materials1);
            }
            // 节能环保-排污许可证办理
            String licence = tTrainDatabase.getLicence();
            SysDictDataResponse licence_tran = sysDictDataController.getDictTypeDetail("", "LICENCE_TRAN", licence).getData();
            if (ObjectHelper.isNotEmpty(licence_tran)) {
                String materials1 = licence_tran.getDictValue();
                tTrainDatabase.setLicence(materials1);
            }

            // 节能环保-环保验收情况
            String checkCase = tTrainDatabase.getCheckCase();
            SysDictDataResponse acceptance_case = sysDictDataController.getDictTypeDetail("", "ACCEPTANCE_CASE", checkCase).getData();
            if (ObjectHelper.isNotEmpty(acceptance_case)) {
                String materials1 = acceptance_case.getDictValue();
                tTrainDatabase.setCheckCase(materials1);
            }

            // 节能环保-是否处于敏感地带
            String sensitiveAreas = tTrainDatabase.getSensitiveAreas();
            SysDictDataResponse sensitivity_zone = sysDictDataController.getDictTypeDetail("", "SENSITIVITY_ZONE", sensitiveAreas).getData();
            if (ObjectHelper.isNotEmpty(sensitivity_zone)) {
                String materials1 = sensitivity_zone.getDictValue();
                tTrainDatabase.setSensitiveAreas(materials1);
            }

            // 节能环保-三线一单是否发布
            String location = tTrainDatabase.getLocation();
            SysDictDataResponse is_release = sysDictDataController.getDictTypeDetail("", "IS_RELEASE", location).getData();
            if (ObjectHelper.isNotEmpty(is_release)) {
                String materials1 = is_release.getDictValue();
                tTrainDatabase.setLocation(materials1);
            }

            data1.add(tTrainDatabase);
        }

        return data1;
    }

    //	@ApiOperation(value = "修改 环保基本面管理 ", notes = "Update TBasicEnvironmentManage By Id")
//	@PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TBasicEnvironmentManage updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TBasicEnvironmentManage data = BeanHelper.beanToBean(updateRequest, TBasicEnvironmentManage.class);
            boolean result = tBasicEnvironmentManageService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    //	@ApiOperation(value = "删除 环保基本面管理 ", notes = "delete TBasicEnvironmentManage By Id")
//	@PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TBasicEnvironmentManageDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TBasicEnvironmentManage data = new TBasicEnvironmentManage();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tBasicEnvironmentManageService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    //	@ApiOperation(value = "批量删除环保基本面管理", notes = "delete TBasicEnvironmentManage by batch Id")
//	@PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TBasicEnvironmentManageDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TBasicEnvironmentManage> tBasicEnvironmentManageList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TBasicEnvironmentManage data = new TBasicEnvironmentManage();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tBasicEnvironmentManageList.add(data);
            }
            boolean result = tBasicEnvironmentManageService.updateBatchById(tBasicEnvironmentManageList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }


    //	@ApiOperation(value = "获取 环保基本面管理 列表", notes = "List TBasicEnvironmentManage all")
//	@GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TBasicEnvironmentManage>> listAllEntity(TBasicEnvironmentManageParam param) {
        BaseResponse<BaseResponseList<TBasicEnvironmentManage>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TBasicEnvironmentManage> queryWrapper = this.createQuery(param);
        List<TBasicEnvironmentManage> resultList = tBasicEnvironmentManageService.list(queryWrapper);
        BaseResponseList<TBasicEnvironmentManage> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TBasicEnvironmentManage> createQuery(TBasicEnvironmentManageParam queryParam) {
        QueryWrapper<TBasicEnvironmentManage> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getLocation())) {
            queryWrapper.eq(TBasicEnvironmentManage.LOCATION, queryParam.getLocation());
        }
        if (StringHelper.isNotEmpty(queryParam.getTroubleshoot())) {
            queryWrapper.eq(TBasicEnvironmentManage.TROUBLESHOOT, queryParam.getTroubleshoot());
        }
        if (StringHelper.isNotEmpty(queryParam.getSensitiveAreas())) {
            queryWrapper.eq(TBasicEnvironmentManage.SENSITIVE_AREAS, queryParam.getSensitiveAreas());
        }
        if (StringHelper.isNotEmpty(queryParam.getCheckCase())) {
            queryWrapper.eq(TBasicEnvironmentManage.CHECK_CASE, queryParam.getCheckCase());
        }
        if (StringHelper.isNotEmpty(queryParam.getLicence())) {
            queryWrapper.eq(TBasicEnvironmentManage.LICENCE, queryParam.getLicence());
        }
        if (StringHelper.isNotEmpty(queryParam.getPollution())) {
            queryWrapper.eq(TBasicEnvironmentManage.POLLUTION, queryParam.getPollution());
        }
        if (StringHelper.isNotEmpty(queryParam.getRiskPoint())) {
            queryWrapper.eq(TBasicEnvironmentManage.RISK_POINT, queryParam.getRiskPoint());
        }
        if (StringHelper.isNotEmpty(queryParam.getIntake())) {
            queryWrapper.eq(TBasicEnvironmentManage.INTAKE, queryParam.getIntake());
        }
        if (StringHelper.isNotEmpty(queryParam.getDrain())) {
            queryWrapper.eq(TBasicEnvironmentManage.DRAIN, queryParam.getDrain());
        }
        if (StringHelper.isNotEmpty(queryParam.getDust())) {
            queryWrapper.eq(TBasicEnvironmentManage.DUST, queryParam.getDust());
        }
        if (StringHelper.isNotEmpty(queryParam.getSo2())) {
            queryWrapper.eq(TBasicEnvironmentManage.SO2, queryParam.getSo2());
        }
        if (StringHelper.isNotEmpty(queryParam.getNox())) {
            queryWrapper.eq(TBasicEnvironmentManage.NOX, queryParam.getNox());
        }
        if (StringHelper.isNotEmpty(queryParam.getVocs())) {
            queryWrapper.eq(TBasicEnvironmentManage.VOCS, queryParam.getVocs());
        }
        if (StringHelper.isNotEmpty(queryParam.getFlueCount())) {
            queryWrapper.eq(TBasicEnvironmentManage.FLUE_COUNT, queryParam.getFlueCount());
        }
        if (StringHelper.isNotEmpty(queryParam.getFlueDeal())) {
            queryWrapper.eq(TBasicEnvironmentManage.FLUE_DEAL, queryParam.getFlueDeal());
        }
        if (StringHelper.isNotEmpty(queryParam.getCodcr())) {
            queryWrapper.eq(TBasicEnvironmentManage.CODCR, queryParam.getCodcr());
        }
        if (StringHelper.isNotEmpty(queryParam.getNh3N())) {
            queryWrapper.eq(TBasicEnvironmentManage.NH3_N, queryParam.getNh3N());
        }
        if (StringHelper.isNotEmpty(queryParam.getWasteCount())) {
            queryWrapper.eq(TBasicEnvironmentManage.WASTE_COUNT, queryParam.getWasteCount());
        }
        if (StringHelper.isNotEmpty(queryParam.getWasteDeal())) {
            queryWrapper.eq(TBasicEnvironmentManage.WASTE_DEAL, queryParam.getWasteDeal());
        }
        if (StringHelper.isNotEmpty(queryParam.getBoilerStage())) {
            queryWrapper.eq(TBasicEnvironmentManage.BOILER_STAGE, queryParam.getBoilerStage());
        }
        if (StringHelper.isNotEmpty(queryParam.getBoilerTon())) {
            queryWrapper.eq(TBasicEnvironmentManage.BOILER_TON, queryParam.getBoilerTon());
        }
        if (StringHelper.isNotEmpty(queryParam.getThenStatus())) {
            queryWrapper.eq(TBasicEnvironmentManage.THEN_STATUS, queryParam.getThenStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getBiologyStage())) {
            queryWrapper.eq(TBasicEnvironmentManage.BIOLOGY_STAGE, queryParam.getBiologyStage());
        }
        if (StringHelper.isNotEmpty(queryParam.getBiologyTon())) {
            queryWrapper.eq(TBasicEnvironmentManage.BIOLOGY_TON, queryParam.getBiologyTon());
        }
        if (StringHelper.isNotEmpty(queryParam.getFuelStage())) {
            queryWrapper.eq(TBasicEnvironmentManage.FUEL_STAGE, queryParam.getFuelStage());
        }
        if (StringHelper.isNotEmpty(queryParam.getFuelTon())) {
            queryWrapper.eq(TBasicEnvironmentManage.FUEL_TON, queryParam.getFuelTon());
        }
        if (StringHelper.isNotEmpty(queryParam.getMajorId())) {
            queryWrapper.eq(TBasicEnvironmentManage.MAJOR_ID, queryParam.getMajorId());
        }
        if (StringHelper.isNotEmpty(queryParam.getMajorName())) {
            queryWrapper.like(TBasicEnvironmentManage.MAJOR_NAME, queryParam.getMajorName());
        }
        if (StringHelper.isNotEmpty(queryParam.getMajorPhone())) {
            queryWrapper.eq(TBasicEnvironmentManage.MAJOR_PHONE, queryParam.getMajorPhone());
        }
        if (StringHelper.isNotEmpty(queryParam.getBranchedLeaderId())) {
            queryWrapper.eq(TBasicEnvironmentManage.BRANCHED_LEADER_ID, queryParam.getBranchedLeaderId());
        }
        if (StringHelper.isNotEmpty(queryParam.getBranchedLeaderName())) {
            queryWrapper.like(TBasicEnvironmentManage.BRANCHED_LEADER_NAME, queryParam.getBranchedLeaderName());
        }
        if (StringHelper.isNotEmpty(queryParam.getBranchedLeaderPhone())) {
            queryWrapper.eq(TBasicEnvironmentManage.BRANCHED_LEADER_PHONE, queryParam.getBranchedLeaderPhone());
        }
        if (StringHelper.isNotEmpty(queryParam.getDeptPersonId())) {
            queryWrapper.eq(TBasicEnvironmentManage.DEPT_PERSON_ID, queryParam.getDeptPersonId());
        }
        if (StringHelper.isNotEmpty(queryParam.getDeptPersonName())) {
            queryWrapper.like(TBasicEnvironmentManage.DEPT_PERSON_NAME, queryParam.getDeptPersonName());
        }
        if (StringHelper.isNotEmpty(queryParam.getDeptPersonPhone())) {
            queryWrapper.eq(TBasicEnvironmentManage.DEPT_PERSON_PHONE, queryParam.getDeptPersonPhone());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnvironPersonId())) {
            queryWrapper.eq(TBasicEnvironmentManage.ENVIRON_PERSON_ID, queryParam.getEnvironPersonId());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnvironPersonName())) {
            queryWrapper.like(TBasicEnvironmentManage.ENVIRON_PERSON_NAME, queryParam.getEnvironPersonName());
        }
        if (StringHelper.isNotEmpty(queryParam.getEnvironPersonPhone())) {
            queryWrapper.eq(TBasicEnvironmentManage.ENVIRON_PERSON_PHONE, queryParam.getEnvironPersonPhone());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgName())) {
            queryWrapper.like(TBasicEnvironmentManage.ORG_NAME, queryParam.getOrgName());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TBasicEnvironmentManage.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TBasicEnvironmentManage.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TBasicEnvironmentManage.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
