package com.testor.module.fives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.fives.dao.TFivesSubOptionDao;
import com.testor.module.fives.model.domain.TFivesSubOption;
import com.testor.module.fives.model.dto.TFivesSubOptionParam;
import com.testor.module.fives.service.TFivesSubOptionService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 5s内容分项Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-11 14:07:47
 */
@Service
public class TFivesSubOptionServiceImpl extends SuperServiceImpl<TFivesSubOptionDao, TFivesSubOption> implements TFivesSubOptionService {
    @Autowired(required = false)
    private TFivesSubOptionDao tFivesSubOptionDao;

    @Override
    public IPage<TFivesSubOption> standardCheck(TFivesSubOptionParam param) {
        Long page = StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TFivesSubOption> resultPage = new Page<>(page, limit);
        return tFivesSubOptionDao.standardCheck(resultPage, param);
    }

    @Override
    public List<String> getMainContent(String id) {
        return tFivesSubOptionDao.getMainContent(id);
    }

    @Override
    public String standardCheckSum(TFivesSubOptionParam query) {
        return tFivesSubOptionDao.standardCheckSum(query);
    }


}
