package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 安全风险分析对象 t_hazard_assessment
 * 
 * @author testor-framework
 * @date 2024-12-24 17:17:29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_assessment")
@ApiModel(value = "THazardAssessment对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardAssessment extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 危险作业计划id
 */
  @ApiModelProperty(value = "危险作业计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 作业类型id
 */
  @ApiModelProperty(value = "作业类型id")

  @TableField("work_type_id")
  private String workTypeId;
/**
 * 参与人签字
 */
  @ApiModelProperty(value = "参与人签字")

  @TableField("participant_signature")
  private String participantSignature;
/**
 * 现场图片
 */
  @ApiModelProperty(value = "现场图片")

  @TableField("site_image")
  private String siteImage;
/**
 * 作业现场负责人签名
 */
  @ApiModelProperty(value = "作业现场负责人签名")

  @TableField("work_site_responsible_signature")
  private String workSiteResponsibleSignature;
/**
 * 签字时间
 */
  @ApiModelProperty(value = "签字时间")

  @TableField("signature_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signatureTime;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String WORK_TYPE_ID ="work_type_id";
  public static final String PARTICIPANT_SIGNATURE ="participant_signature";
  public static final String SITE_IMAGE ="site_image";
  public static final String WORK_SITE_RESPONSIBLE_SIGNATURE ="work_site_responsible_signature";
  public static final String SIGNATURE_TIME ="signature_time";


}
