package com.testor.module.hazard.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import com.testor.module.hazard.model.domain.THazardWorkPlanCheck;

/**
 * 危险作业计划监督检查 删除参数对象
 *
 * @author testor-framework
 * @date 2025-04-16 10:09:22
 */

@Data
@ApiModel(value = "THazardWorkPlanCheck 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class THazardWorkPlanCheckParam extends THazardWorkPlanCheck {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "关键字")
	private String keywords;

	/**
	 * 单位id集合
	 */
	@ApiModelProperty(value = "单位id集合")
	private List<String> orgIdList;

	@ApiModelProperty(value = "检查开始时间")
	private String startTime;

	@ApiModelProperty(value = "检查结束时间")
	private String endTime;

	@ApiModelProperty(value = "本机构数据")
	private boolean thisOrg;

	@ApiModelProperty(value = "orgId(下钻条件传)")
	private String orgId;

}
