package com.testor.module.hazard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.dao.TContractorAccessLogApprovalDao;
import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.testor.module.hazard.model.domain.TContractorAccessLogApproval;
import com.testor.module.hazard.model.dto.TContractorAccessLogApprovalParam;
import com.testor.module.hazard.model.dto.TContractorAccessLogParam;
import com.testor.module.hazard.service.TContractorAccessLogApprovalService;
import com.testor.module.hazard.service.TContractorAccessLogService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TContractorAccessLogApprovalServiceImpl extends SuperServiceImpl<TContractorAccessLogApprovalDao, TContractorAccessLogApproval> implements TContractorAccessLogApprovalService {

    @Autowired
    private TContractorAccessLogService contractorAccessLogService;

    @Override
    public void insertBatchContractorAccessLog(List<TContractorAccessLogApproval> tContractorAccessLogApprovals) {
        this.saveBatch(tContractorAccessLogApprovals);
    }

    @Override
    public Page<TContractorAccessLogApproval> queryContractorAccessLogApproval(TContractorAccessLogApprovalParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TContractorAccessLogApproval> resultPage = new Page<>(page, limit); // 修改此处泛型类型
        QueryWrapper<TContractorAccessLogApproval> queryWrapper = this.createQuery(param);
        Page<TContractorAccessLogApproval> tContractorAccessLogPage = this.page(resultPage, queryWrapper);
        tContractorAccessLogPage.getRecords().forEach(tContractorAccessLogApproval -> {
            tContractorAccessLogApproval.setTContractorAccessLog(
                    contractorAccessLogService.getById(tContractorAccessLogApproval.getTContractorAccessLog()));
        });
        return tContractorAccessLogPage;
    }

    @Override
    public List<TContractorAccessLogApproval> selectByContractorAllowIdAndCreateBy(String contractorAllowId, String createBy) {
        return baseMapper.selectByContractorAllowIdAndCreateBy(contractorAllowId, createBy);
    }

    @Override
    public int selectCountByContractorAllowIdAndApprovalStatus(String contractorAllowId, String approvalStatus) {
        return baseMapper.selectCountByContractorAllowIdAndApprovalStatus(contractorAllowId, approvalStatus);
    }

    @Override
    public int updateApprovalStatus(List<String> ids, String approvalStatus) {
        return baseMapper.updateApprovalStatus(ids, approvalStatus);
    }

    private QueryWrapper<TContractorAccessLogApproval> createQuery(TContractorAccessLogApprovalParam queryParam) {
        QueryWrapper<TContractorAccessLogApproval> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getContractorAllowId())) {
            queryWrapper.like("contractor_allow_id", queryParam.getContractorAllowId());
        }

        if (StringHelper.isNotEmpty(queryParam.getApprovalStatus())) {
            queryWrapper.like("approval_status", queryParam.getApprovalStatus());
        }
        queryWrapper.orderByDesc(TContractorAccessLogApproval.CREATE_DATE);
        return queryWrapper;
    }

}
