package com.testor.module.hire.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hire.entity.DepositoryManageBase;
import com.testor.module.hire.entity.vo.HireDepositoryDto;
import com.testor.module.hire.entity.vo.HireDepositoryListVo;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 租赁库管理-客商基本信息 Mapper 接口
 * </p>
 *
 * @author caoqiang
 * @since 2024-08-29
 */
public interface DepositoryManageBaseMapper extends BaseMapper<DepositoryManageBase> {

    /**
     * 查询租赁库列表
     *
     * @param param 查询条件
     * @return 租赁库列表
     */
    IPage<HireDepositoryDto> findDepositoryList(Page<DepositoryManageBase> page, @Param("param") HireDepositoryListVo param);
}
