package com.testor.module.threeframework.model.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;


/**
 * 三同时管理对象 t_three_time
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:20
 */
@Data
@ApiModel(value = "TThreeTime对象", description = "")
public class TThreeTimeVO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    private String processStatus;
    /**
     * 项目编号
     */
    @ApiModelProperty(value = "项目编号")
    private String serialNumber;
    /**
     * 建设单位
     */
    @ApiModelProperty(value = "建设单位id")
    private String orgId;

    /**
     * 建设单位
     */
    @ApiModelProperty(value = "建设单位名称")
    private String orgName;
    /**
     * 项目性质（字典配置）
     */
    @ApiModelProperty(value = "项目性质（字典配置）")
    private String projectNature;
    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")
    private String name;
    /**
     * 立项时间
     */
    @ApiModelProperty(value = "立项时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date projectApprovalDate;
    /**
     * 项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）
     */
    @ApiModelProperty(value = "项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）")
    private String plan;
    /**
     * 项目简介
     */
    @ApiModelProperty(value = "项目简介")
    private String intro;
    /**
     * 安全（预）评价（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "安全（预）评价（1-完成/0-未完成）")
    private String safetyEvaluation;
    /**
     * 环境影响评价（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "环境影响评价（1-完成/0-未完成）")
    private String evlAppraisal;
    /**
     * 安全设施设计专篇（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "安全设施设计专篇（1-完成/0-未完成）")
    private String safetyFacilities;
    /**
     * 环境保护设施设计专篇（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "环境保护设施设计专篇（1-完成/0-未完成）")
    private String evlProtection;
    /**
     * 施工基本信息（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "施工基本信息（1-完成/0-未完成）")
    private String construction;
    /**
     * 安全验收评价（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "安全验收评价（1-完成/0-未完成）")
    private String safetyAcceptance;
    /**
     * 环保验收监测（调查）（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "环保验收监测（调查）（1-完成/0-未完成）")
    private String evlSurvey;
    /**
     * 后评价基本信息（1-完成/0-未完成）
     */
    @ApiModelProperty(value = "后评价基本信息（1-完成/0-未完成）")
    private String postEvaluation;

    @ApiModelProperty(value = "  1-是 0-否")
    private String dangerousProjectsState;


    @ApiModelProperty(value = "项目造价")
    private String projectCost;

    @ApiModelProperty(value = "项目级别")
    private String projectLevel;

    @ApiModelProperty(value = "项目周期")
    private String projectDuration;

    @ApiModelProperty(value = "项目主管部门")
    private String projectSupervisingDepartment;

    @ApiModelProperty(value = "计划开工时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date plannedStartDate;

    @ApiModelProperty(value = "计划竣工时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date plannedEndDate;

    @ApiModelProperty(value = "施工单位名称")
    private String constructionCompanyName;

    @ApiModelProperty(value = "监理单位名称")
    private String supervisionCompanyName;

    @ApiModelProperty(value = "项目经理")
    private String projectManager;

    @ApiModelProperty(value = "联系方式")
    private String contactNumber;

    @ApiModelProperty(value = "安全监理")
    private String safetySupervision;

    @ApiModelProperty(value = "安全监理联系方式")
    private String safetyContactNumber;




    @ApiModelProperty("附件")
    private List<TThreeTimeAuxiliaryVO> auxiliaryList;
}
