package com.testor.module.train.project.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 记录用户外部培训和考试信息
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-07
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_train_exams_external_info")
public class TrainExamsExternalInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private String id;

    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;

    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    @TableLogic
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_date")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("update_date")
    private Date updateDate;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;

    /**
     * 培训项目名称
     */
    @TableField("train_name")
    private String trainName;

    /**
     * 课程名称
     */
    @TableField("course_name")
    private String courseName;

    /**
     * 人员类型 
     */
    @TableField("user_type_code")
    private String userTypeCode;

    /**
     * 参训方式  线上 /线下
     */
    @TableField("train_type")
    private String trainType;

    /**
     * 参训时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("train_start_time")
    private Date trainStartTime;

    /**
     * 参训时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("train_end_time")
    private Date trainEndTime;

    /**
     * 参训地点
     */
    @TableField("train_address")
    private String trainAddress;

    /**
     * 是否参加考试 0 否 1 是 
     */
    @TableField("take_exam_state")
    private String takeExamState;

    /**
     * 考试名称
     */
    @TableField("exam_name")
    private String examName;

    /**
     * 考试类型：线上 /线下
     */
    @TableField("exam_type")
    private String examType;

    /**
     * 考试时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("exam_start_time")
    private Date examStartTime;

    /**
     * 考试时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("exam_end_time")
    private Date examEndTime;

    /**
     * 考试地点
     */
    @TableField("exam_address")
    private String examAddress;

    /**
     * 考试时长
     */
    @TableField("exam_duration")
    private String examDuration;

    /**
     * 考试得分
     */
    @TableField("exam_score")
    private String examScore;

    /**
     * 附件id
     */
    @TableField("ref_id")
    private String refId;

    /**
     * 评价信息
     */
    @TableField("evaluation")
    private String evaluation;

    /**
     * 评价总分
     */
    @TableField("evaluation_score")
    private String evaluationScore;


    public static final String ID = "id";

    public static final String USER_ID = "user_id";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

    public static final String REMARKS = "remarks";

    public static final String TRAIN_NAME = "train_name";

    public static final String COURSE_NAME = "course_name";

    public static final String USER_TYPE_CODE = "user_type_code";

    public static final String TRAIN_TYPE = "train_type";

    public static final String TRAIN_START_TIME = "train_start_time";

    public static final String TRAIN_END_TIME = "train_end_time";

    public static final String TRAIN_ADDRESS = "train_address";

    public static final String TAKE_EXAM_STATE = "take_exam_state";

    public static final String EXAM_NAME = "exam_name";

    public static final String EXAM_TYPE = "exam_type";

    public static final String EXAM_START_TIME = "exam_start_time";

    public static final String EXAM_END_TIME = "exam_end_time";

    public static final String EXAM_ADDRESS = "exam_address";

    public static final String EXAM_DURATION = "exam_duration";

    public static final String EXAM_SCORE = "exam_score";

    public static final String REF_ID = "ref_id";

    public static final String EVALUATION = "evaluation";

    public static final String EVALUATION_SCORE = "evaluation_score";

}
