/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.auth.interceptor;

import com.tongtech.tfw.backend.common.biz.models.BaseRequest;
import com.tongtech.tfw.backend.common.constants.SignatureConstants;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.common.response.ResponseUtil;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.map.MapKeyComparator;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;

public class DataSignatureInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataSignatureInterceptor.class);
    @Value(value="${auth.sign.ignoreGet:false}")
    private boolean ignoreGet;
    @Value(value="${auth.sign.timeGap:36000}")
    private long timeGap;
    private String signKey = "123456789";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object obj) {
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        if (this.ignoreGet && RequestUtil.isGet((HttpServletRequest)request)) {
            return true;
        }
        if (ObjectHelper.isEmpty((Object)this.timeGap) || this.timeGap < SignatureConstants.TIMESTAMP_MIN_GAP) {
            this.timeGap = SignatureConstants.TIMESTAMP_VALID_GAP;
        }
        log.info("Time Gap value = " + this.timeGap);
        request.setAttribute("signKey", (Object)this.signKey);
        BaseRequest params = new BaseRequest();
        String requestBody = RequestUtil.getRequestBody((HttpServletRequest)httpRequest);
        if (StringHelper.isNotEmpty((CharSequence)requestBody)) {
            params.setData((Object)requestBody);
        } else {
            StringBuilder data = new StringBuilder();
            StandardServletMultipartResolver commonsMultipartResolver = new StandardServletMultipartResolver();
            if (!commonsMultipartResolver.isMultipart(httpRequest)) {
                Map pam = request.getParameterMap();
                if (ObjectHelper.isNotEmpty((Object)pam) && pam.size() > 0) {
                    pam = MapKeyComparator.sortMapByKey((Map)pam);
                }
                for (String key : pam.keySet()) {
                    String value = Arrays.toString((Object[])pam.get(key));
                    data.append(key).append(StringHelper.substring((String)value, (int)1, (int)(value.length() - 1)));
                }
            }
            params.setData((Object)data.toString());
        }
        params.setTimestamp(RequestUtil.getTimestamp((HttpServletRequest)request));
        params.setSign(RequestUtil.getDataSign((HttpServletRequest)request));
        if (ObjectHelper.isEmpty((Object)params.getTimestamp())) {
            this.sendSignFail(httpRequest, httpResponse, BaseStatusEnum.UN_TIMESTAMP.transform());
            return false;
        }
        if (System.currentTimeMillis() > params.getTimestamp() + this.timeGap) {
            log.info("Timestamp expired, current: " + System.currentTimeMillis() + " , received: " + params.getTimestamp());
            this.sendSignFail(httpRequest, httpResponse, BaseStatusEnum.UN_VALID_TIMESTAMP.transform());
            return false;
        }
        if (StringHelper.isBlank((CharSequence)params.getSign())) {
            this.sendSignFail(httpRequest, httpResponse, BaseStatusEnum.UN_SIGN.transform());
            return false;
        }
        String calculateSign = DigestUtils.md5Hex((byte[])(this.signKey + params.getTimestamp() + params.jsonFormat()).getBytes(StandardCharsets.UTF_8));
        if (!calculateSign.equalsIgnoreCase(params.getSign())) {
            log.info("Signature Fail, Expect Sign: " + calculateSign + "  , but receive : " + params.getSign() + " , Timestamp : " + params.getTimestamp());
            this.sendSignFail(httpRequest, httpResponse, BaseStatusEnum.SIGN_ERROR.transform());
            return false;
        }
        return true;
    }

    private void sendSignFail(HttpServletRequest request, HttpServletResponse response, ResponseInfo apiStatusInfo) {
        response.setStatus(200);
        ResponseUtil.response((HttpServletRequest)request, (HttpServletResponse)response, (ResponseInfo)apiStatusInfo, null);
    }
}

