/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.user.controller;

import com.alibaba.excel.EasyExcel;
import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.dysmsapi20170525.AsyncClient;
import com.aliyun.sdk.service.dysmsapi20170525.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendSmsResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.gson.Gson;
import com.testor.biz.auth.AuthEnumCode;
import com.testor.biz.excel.ExcelEnum;
import com.testor.biz.excel.model.ImportError;
import com.testor.biz.excel.service.ExcelService;
import com.testor.biz.excel.service.TongExcelListener;
import com.testor.biz.excel.support.ExcelDtoHelper;
import com.testor.biz.file.FileEnumCode;
import com.testor.biz.file.model.domain.TSysFileBiz;
import com.testor.biz.file.service.TSysFileBizService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.position.service.TSysJobPositionService;
import com.testor.biz.sys.post.model.domain.TSysPost;
import com.testor.biz.sys.post.service.TSysPostService;
import com.testor.biz.sys.role.model.domain.SysRole;
import com.testor.biz.sys.role.service.SysRoleService;
import com.testor.biz.sys.user.UserEnumCode;
import com.testor.biz.sys.user.UserHelper;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.model.domain.UpdatePassword;
import com.testor.biz.sys.user.model.domain.UpdatePhone;
import com.testor.biz.sys.user.model.dto.SysUserChangePwdRequest;
import com.testor.biz.sys.user.model.dto.SysUserCreateAndUpdateRequest;
import com.testor.biz.sys.user.model.dto.SysUserDeleteBatchRequest;
import com.testor.biz.sys.user.model.dto.SysUserDeleteRequest;
import com.testor.biz.sys.user.model.dto.SysUserListResponse;
import com.testor.biz.sys.user.model.dto.SysUserParam;
import com.testor.biz.sys.user.model.dto.SysUserPositionRequest;
import com.testor.biz.sys.user.model.dto.SysUserResponse;
import com.testor.biz.sys.user.model.dto.SysUserRoleRequest;
import com.testor.biz.sys.user.model.dto.UserExport;
import com.testor.biz.sys.user.model.dto.UserImport;
import com.testor.biz.sys.user.model.dto.UserImportError;
import com.testor.biz.sys.user.model.dto.UserImportResponse;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.biz.sys.user.service.UserExcelImportService;
import com.testor.biz.sys.userRole.model.domain.SysUserRole;
import com.testor.biz.sys.userRole.service.SysUserRoleService;
import com.testor.biz.sys.userposition.model.domain.TSysUserPosition;
import com.testor.biz.sys.userposition.service.TSysUserPositionService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import darabonba.core.client.ClientOverrideConfiguration;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(value="SysUser", tags={"SysUser \u7528\u6237"})
@RequestMapping(value={"/user"})
public class SysUserController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private TSysUserPositionService tSysUserPositionService;
    @Autowired
    private TSysJobPositionService tSysJobPositionService;
    @Autowired
    private TSysFileBizService tSysFileBizService;
    @Autowired
    private ExcelService excelService;
    @Autowired
    UserExcelImportService userExcelImportService;
    @Autowired
    private TSysPostService tSysPostService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String UPDATE_PHONE = "UPDATE_PHONE";
    private static final String UPDATE_PASSWORD = "UPDATE_PASSWORD";

    public void sendCode(String phone, String num) {
        StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId("LTAI5tF5NH7XpFEy8igjaHbq").accessKeySecret("uKALdkM6rXw12VwjWjDbgODY6XTniZ").build());
        AsyncClient client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region("cn-hangzhou")).credentialsProvider((ICredentialProvider)provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride("dysmsapi.aliyuncs.com"))).build();
        SendSmsRequest sendSmsRequest = SendSmsRequest.builder().signName("xx").phoneNumbers(phone).templateCode("SMS_267090386").templateParam("{\"code\": \"" + num + "\"}").build();
        CompletableFuture response = client.sendSms(sendSmsRequest);
        SendSmsResponse resp = null;
        try {
            resp = (SendSmsResponse)response.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        System.out.println(new Gson().toJson((Object)resp));
        client.close();
    }

    @ApiOperation(value="\u53d1\u9001\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getCode"})
    public BaseResponse<String> getCode(@ApiParam(value="\u624b\u673a\u53f7") String phone, @ApiParam(value="\u9a8c\u8bc1\u7801\u7528\u9014 1(\u4fee\u6539\u5bc6\u7801) 2(\u4fee\u6539\u624b\u673a\u53f7)") String status) throws Exception {
        String code = "";
        if ("1".equals(status)) {
            code = UPDATE_PASSWORD;
        } else if ("2".equals(status)) {
            code = UPDATE_PHONE;
        }
        BaseResponse response = new BaseResponse();
        this.verificationResult(phone);
        String verifyCode = String.valueOf((int)(Math.random() * 900000.0 + 100000.0));
        this.stringRedisTemplate.opsForValue().set((Object)(code + phone), (Object)verifyCode, 300L, TimeUnit.SECONDS);
        response.setData((Object)verifyCode);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verificationResult(String phone) throws Exception {
        if (!StringHelper.isNotEmpty((CharSequence)phone)) return;
        Boolean phoneLegal = this.isPhoneLegal(phone);
        if (!phoneLegal.booleanValue()) throw new BusinessException("\u624b\u673a\u53f7\u975e\u6cd5");
        SysUser sysUser = (SysUser)((Object)this.sysUserService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"phone_no", (Object)phone)).ne((Object)"status", (Object)"1")));
        if (!ObjectHelper.isNotEmpty((Object)((Object)sysUser))) throw new BusinessException("\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        if ("0".equals(sysUser.getStatus())) return;
        throw new ApiException(AuthEnumCode.STATUS.transform());
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/updatePassword"})
    public BaseResponse<UpdatePassword> updatePassword(@RequestBody UpdatePassword updatePassword) throws Exception {
        BaseResponse response = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updatePassword)) {
            String phone = updatePassword.getPhone();
            String password = updatePassword.getPassword();
            String verificationCode = updatePassword.getVerificationCode();
            this.verificationResult(phone);
            String ver = (String)this.stringRedisTemplate.opsForValue().get((Object)(UPDATE_PASSWORD + phone));
            if (!verificationCode.equals(ver)) {
                throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            String PWD = UserHelper.userPassword(password);
            boolean update = this.sysUserService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"phone_no", (Object)phone)).ne((Object)"status", (Object)"1")).set((Object)"login_pwd", (Object)PWD));
            if (update) {
                this.stringRedisTemplate.delete((Object)(UPDATE_PASSWORD + phone));
                response.setData((Object)updatePassword);
            }
        }
        return response;
    }

    @ApiOperation(value="\u4fee\u6539\u624b\u673a\u53f7")
    @PostMapping(value={"/updatePhone"})
    public BaseResponse<UpdatePhone> updatePhone(@RequestBody UpdatePhone updatePhone) throws Exception {
        BaseResponse response = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updatePhone)) {
            String rawPhone = updatePhone.getRawPhone();
            String newPhone = updatePhone.getNewPhone();
            String verificationCode = updatePhone.getVerificationCode();
            this.verificationResult(rawPhone);
            Boolean phoneLegal = this.isPhoneLegal(newPhone);
            if (phoneLegal.booleanValue()) {
                String ver = (String)this.stringRedisTemplate.opsForValue().get((Object)(UPDATE_PHONE + rawPhone));
                if (!verificationCode.equals(ver)) {
                    throw new BusinessException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                }
                boolean update = this.sysUserService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"phone_no", (Object)rawPhone)).ne((Object)"status", (Object)"1")).set((Object)"phone_no", (Object)newPhone));
                if (update) {
                    this.stringRedisTemplate.delete((Object)(UPDATE_PHONE + rawPhone));
                    SysUser one = (SysUser)((Object)this.sysUserService.getOne((Wrapper)new QueryWrapper().eq((Object)"phone_no", (Object)newPhone)));
                    UpdatePhone phone = new UpdatePhone();
                    phone.setNewPhone(one.getPhoneNo());
                    phone.setLoginName(one.getLoginName());
                    response.setData((Object)phone);
                }
            } else {
                throw new BusinessException("\u65b0\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
            }
        }
        return response;
    }

    private Boolean isPhoneLegal(String phone) {
        String regex = "^((13[0-9])|(14[05679])|(15([0-3,5-9]))|(16[2567])|(17[01235678])|(18[0-9]|19[135689]))\\d{8}$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(phone);
        boolean isMatch = m.matches();
        return isMatch;
    }

    @ApiOperation(value="\u3010\u83b7\u53d6\u7528\u6237\u5217\u8868\u4fe1\u606f\u3011", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868\u4fe1\u606f List User")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysUserListResponse>> listEntity(@Valid SysUserParam param) {
        BaseResponse baseResponse = new BaseResponse();
        List sysOrgList = StringHelper.isEmpty((CharSequence)param.getOrgId()) ? this.sysOrgService.list((Wrapper)new QueryWrapper().select(new String[]{"org_id", "org_name"})) : this.sysOrgService.getChildrenDept(param.getOrgId());
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysUser> queryWrapper = this.createQuery(param);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SysOrg sysOrg : sysOrgList) {
            arrayList.add(sysOrg.getOrgId());
        }
        if (arrayList.size() > 0) {
            queryWrapper.in((Object)"dept_id", arrayList);
        }
        Page resultList = (Page)this.sysUserService.page((IPage)resultPage, (Wrapper)queryWrapper);
        List finalSysOrgList = sysOrgList;
        List records = resultList.getRecords().stream().map(bean -> (SysUserListResponse)bean.beanToBean(SysUserListResponse.class)).peek(bean -> finalSysOrgList.stream().filter(sysOrg -> sysOrg.getOrgId().equals(bean.getDeptId())).forEach(sysOrg -> bean.setDeptName(sysOrg.getOrgName()))).collect(Collectors.toList());
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(records);
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u65b0\u589e\u7528\u6237\u57fa\u672c\u4fe1\u606f\u3011", notes="\u65b0\u589e\u7528\u6237\u57fa\u672c\u4fe1\u606f Add user")
    @PostMapping(value={"/add"})
    public BaseResponse<SysUser> addEntity(@Valid @RequestBody SysUserCreateAndUpdateRequest addRequest) {
        SysUser data;
        String userId;
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)addRequest)) {
            throw new ApiException(UserEnumCode.USER_PARAM_IS_NULL.transform());
        }
        if (StringHelper.isEmpty((CharSequence)addRequest.getLoginPwd())) {
            throw new ApiException(UserEnumCode.REQUIRED_ITEMS_MISSING.transform());
        }
        if (!StringHelper.isEmpty((CharSequence)addRequest.getOrgId()) && !ObjectHelper.isEmpty((Object)this.sysOrgService.getById((Serializable)((Object)addRequest.getOrgId())))) {
            SysUser existsSysUser = (SysUser)((Object)this.sysUserService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"login_name", (Object)addRequest.getLoginName())).ne((Object)"status", (Object)"1")).last("LIMIT 1")));
            if (ObjectHelper.isNotEmpty((Object)((Object)existsSysUser))) {
                throw new ApiException(UserEnumCode.LOGIN_NAME_ALREADY_EXISTS.transform());
            }
            userId = IdHelper.getId32bit();
            if (ObjectHelper.isNotEmpty(addRequest.getFiles()) && !addRequest.getFiles().isEmpty()) {
                List<TSysFileBiz> fileBizList = addRequest.getFiles();
                boolean fileBizResult = this.tSysFileBizService.saveFileBizs(fileBizList, userId, this.getUserId());
                if (!fileBizList.isEmpty() && !fileBizResult) {
                    throw new ApiException(FileEnumCode.FILE_BIZ_SAVE_FAILED.transform());
                }
            }
            data = (SysUser)((Object)BeanHelper.beanToBean((Object)addRequest, SysUser.class));
            SysOrg one = (SysOrg)((Object)this.sysOrgService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)data.getOrgId())).ne((Object)"status", (Object)"1")));
            data.setOrgName(one.getOrgName());
            data.setOrgId(one.getParentId());
            data.setDeptId(addRequest.getOrgId());
            TSysPost tSysPost = (TSysPost)((Object)this.tSysPostService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)data.getPostId())).ne((Object)"status", (Object)"1")));
            if (ObjectHelper.isNotEmpty((Object)((Object)tSysPost))) {
                data.setPostName(tSysPost.getPostName());
            }
            if (StringHelper.isEmpty((CharSequence)data.getLoginPwd())) {
                data.setLoginPwd("123456");
            }
        } else {
            throw new ApiException(UserEnumCode.USER_ORG_ID_ERROR.transform());
        }
        data.setLoginPwd(UserHelper.userPassword(data.getLoginPwd()));
        data.setUserId(userId);
        this.sysUserService.save((Object)data);
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f edit user")
    @PutMapping(value={"/update"})
    public BaseResponse<SysUser> updateEntity(@Valid @RequestBody SysUserCreateAndUpdateRequest updateRequest) {
        SysUser newUser;
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)updateRequest)) {
            throw new ApiException(UserEnumCode.USER_PARAM_IS_NULL.transform());
        }
        if (StringHelper.isEmpty((CharSequence)updateRequest.getUserId())) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        SysOrg sysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)updateRequest.getOrgId())));
        if (!StringHelper.isEmpty((CharSequence)updateRequest.getOrgId()) && ObjectHelper.isNotEmpty((Object)((Object)sysOrg))) {
            SysUser temp;
            newUser = (SysUser)((Object)BeanHelper.beanToBean((Object)updateRequest, SysUser.class));
            SysUser oldUser = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)newUser.getUserId())));
            if (!newUser.getLoginName().equals(oldUser.getLoginName()) && ObjectHelper.isNotEmpty((Object)((Object)(temp = (SysUser)((Object)this.sysUserService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"login_name", (Object)newUser.getLoginName())).ne((Object)"status", (Object)"1")).last("LIMIT 1"))))))) {
                throw new ApiException(UserEnumCode.LOGIN_NAME_ALREADY_EXISTS.transform());
            }
            if (StringHelper.isEmpty((CharSequence)newUser.getLoginPwd())) {
                newUser.setLoginPwd(oldUser.getLoginPwd());
            } else {
                newUser.setLoginPwd(UserHelper.userPassword(newUser.getLoginPwd()));
            }
            if (ObjectHelper.isNotEmpty(updateRequest.getFiles()) && !updateRequest.getFiles().isEmpty()) {
                List<TSysFileBiz> fileBizList = updateRequest.getFiles();
                boolean fileBizResult = this.tSysFileBizService.saveFileBizs(fileBizList, updateRequest.getUserId(), this.getUserId());
                if (!fileBizList.isEmpty() && !fileBizResult) {
                    throw new ApiException(FileEnumCode.FILE_BIZ_SAVE_FAILED.transform());
                }
            }
        } else {
            throw new ApiException(UserEnumCode.USER_ORG_ID_ERROR.transform());
        }
        newUser.setDeptId(updateRequest.getOrgId());
        newUser.setOrgId(sysOrg.getParentId());
        newUser.setOrgName(sysOrg.getOrgName());
        this.sysUserService.updateById((Object)newUser);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u4fe1\u606f get User By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysUserResponse> getEntity(String userId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)userId)) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        SysUser user = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)userId)));
        if (ObjectHelper.isEmpty((Object)((Object)user))) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        SysUserResponse sysUserResponse = (SysUserResponse)((Object)BeanHelper.beanToBean((Object)((Object)user), SysUserResponse.class));
        SysOrg org = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)user.getOrgId())));
        if (!ObjectHelper.isEmpty((Object)((Object)org))) {
            sysUserResponse.setOrgName(org.getOrgName());
        }
        baseResponse.setData((Object)sysUserResponse);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u5220\u9664\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237ID\u5220\u9664\u7528\u6237\u4fe1\u606f delete user by id")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/delete"})
    public BaseResponse<SysUser> deleteEntity(@Valid @RequestBody SysUserDeleteRequest deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)deleteRequest)) {
            throw new ApiException(UserEnumCode.REQUIRED_ITEMS_MISSING.transform());
        }
        SysUser sysUser = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)deleteRequest.getUserId())));
        if (ObjectHelper.isEmpty((Object)((Object)sysUser))) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        this.tSysFileBizService.remove((Wrapper)new QueryWrapper().eq((Object)"biz_id", (Object)deleteRequest.getUserId()));
        sysUser.setStatus("1");
        this.sysUserService.updateById((Object)sysUser);
        this.sysUserRoleService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)sysUser.getUserId()));
        this.tSysUserPositionService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)sysUser.getUserId()));
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u5220\u9664\u7528\u6237\u4fe1\u606f\uff08\u6279\u91cf\uff09", notes="\u6839\u636e\u7528\u6237ID\u5220\u9664\u7528\u6237\u4fe1\u606f\uff08\u6279\u91cf\uff09delete user by ids")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<SysUser> deleteEntities(@Valid @RequestBody SysUserDeleteBatchRequest deleteBatchRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)deleteBatchRequest)) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        List ids = Arrays.stream(deleteBatchRequest.getUserId()).collect(Collectors.toList());
        Collection users = this.sysUserService.listByIds(ids).stream().map(user -> ((SysUser.SysUserBuilder)SysUser.builder().userId(user.getUserId()).status("1")).build()).collect(Collectors.toList());
        this.sysUserRoleService.remove((Wrapper)new QueryWrapper().in((Object)"user_id", ids));
        this.tSysUserPositionService.remove((Wrapper)new QueryWrapper().in((Object)"user_id", ids));
        this.sysUserService.updateBatchById(users);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8be5\u7528\u6237\u6240\u62e5\u6709\u7684\u89d2\u8272\u5217\u8868", notes="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8be5\u7528\u6237\u6240\u62e5\u6709\u7684\u89d2\u8272\u5217\u8868 get roles by user")
    @GetMapping(value={"/show"})
    public BaseResponse<List<Map<String, Object>>> showEntities(String userId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)userId)) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        SysUser user = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)userId)));
        SysOrg org = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)user.getOrgId())));
        LambdaQueryWrapper roleAllQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)roleAllQuery.ne(SuperModel::getStatus, (Object)"1")).eq(SysRole::getTreeLevel, (Object)org.getTreeLevel());
        List roles = this.sysRoleService.list((Wrapper)roleAllQuery);
        List checkedRoles = this.sysUserRoleService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        List checkedRoleIds = checkedRoles.stream().map(SysUserRole::getRoleId).collect(Collectors.toList());
        List data = BeanHelper.beansToMaps((List)roles);
        for (Map role : data) {
            if (checkedRoleIds.contains(String.valueOf(role.get("roleId")))) {
                role.put("isChecked", true);
                continue;
            }
            role.put("isChecked", false);
        }
        baseResponse.setData((Object)data);
        return baseResponse;
    }

    @ApiOperation(value="\u7ed9\u7528\u6237\u5206\u914d\u89d2\u8272", notes="\u7ed9\u7528\u6237\u5206\u914d\u89d2\u8272 assign role to user")
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/assign"})
    public BaseResponse<SysUser> assignEntity(@RequestBody SysUserRoleRequest assignRequest) {
        BaseResponse baseResponse = new BaseResponse();
        this.sysUserRoleService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)assignRequest.getUserId()));
        if (ObjectHelper.isNotEmpty((Object)assignRequest.getRoleId())) {
            ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>(16);
            for (String roleId : assignRequest.getRoleId()) {
                userRoles.add(new SysUserRole().setUserId(assignRequest.getUserId()).setRoleId(roleId));
            }
            this.sysUserRoleService.saveBatch(userRoles);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8be5\u7528\u6237\u6240\u62e5\u6709\u7684\u5c97\u4f4d\u5217\u8868", notes="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8be5\u7528\u6237\u6240\u62e5\u6709\u7684\u5c97\u4f4d\u5217\u8868 get positions by user")
    @GetMapping(value={"/showPosition"})
    public BaseResponse<List<Map<String, Object>>> showPosition(String userId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)userId)) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        List positions = this.tSysJobPositionService.list((Wrapper)new QueryWrapper().ne(true, (Object)"status", (Object)"1"));
        List checkedPositions = this.tSysUserPositionService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        List checkedRoleIds = checkedPositions.stream().map(TSysUserPosition::getPositionId).collect(Collectors.toList());
        List data = BeanHelper.beansToMaps((List)positions);
        for (Map position : data) {
            if (checkedRoleIds.contains(String.valueOf(position.get("positionId")))) {
                position.put("isChecked", true);
                continue;
            }
            position.put("isChecked", false);
        }
        baseResponse.setData((Object)data);
        return baseResponse;
    }

    @ApiOperation(value="\u7ed9\u7528\u6237\u5206\u914d\u5c97\u4f4d", notes="\u7ed9\u7528\u6237\u5206\u914d\u5c97\u4f4d assign position to user")
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/assignPosition"})
    public BaseResponse<SysUser> assignPosition(@RequestBody SysUserPositionRequest assignRequest) {
        BaseResponse baseResponse = new BaseResponse();
        this.tSysUserPositionService.remove((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)assignRequest.getUserId()));
        ArrayList userPositions = new ArrayList(16);
        if (ObjectHelper.isNotEmpty((Object)assignRequest.getPositionId())) {
            for (String positionId : assignRequest.getPositionId()) {
                userPositions.add(((TSysUserPosition.TSysUserPositionBuilder)((TSysUserPosition.TSysUserPositionBuilder)((TSysUserPosition.TSysUserPositionBuilder)TSysUserPosition.builder().id(IdHelper.getId32bit())).positionId(positionId)).userId(assignRequest.getUserId())).build());
            }
            this.tSysUserPositionService.saveBatch(userPositions);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u3010\u6839\u636e\u90e8\u95e8id\u83b7\u53d6\u4eba\u5458\u3011", notes="\u83b7\u53d6\u90e8\u95e8\u4e0b\u7684\u4eba\u5458\u4fe1\u606f")
    @GetMapping(value={"/getPerson"})
    public BaseResponse<List<SysUserListResponse>> getPerson(String orgId) {
        BaseResponse baseResponse = new BaseResponse();
        List list = this.sysUserService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dept_id", (Object)orgId)).ne((Object)"status", (Object)"1"));
        List collect = list.stream().map(bean -> (SysUserListResponse)bean.beanToBean(SysUserListResponse.class)).collect(Collectors.toList());
        baseResponse.setData(collect);
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801", notes="\u4fee\u6539\u7528\u6237\u5bc6\u7801 edit password")
    @PutMapping(value={"/password/update"})
    public BaseResponse<SysUser> passwordEntity(@Valid @RequestBody SysUserChangePwdRequest pwdRequest) {
        BaseResponse baseResponse = new BaseResponse();
        SysUser user = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)pwdRequest.getUserId())));
        String oldPassword = UserHelper.userPassword(pwdRequest.getOldLoginPwd());
        String newPassword = UserHelper.userPassword(pwdRequest.getNewLoginPwd());
        if (ObjectHelper.isEmpty((Object)((Object)user))) {
            throw new ApiException(UserEnumCode.USER_ID_ERROR.transform());
        }
        if (!oldPassword.equals(user.getLoginPwd())) {
            throw new ApiException(UserEnumCode.USER_PWD_MISMATCH.transform());
        }
        user.setLoginPwd(newPassword);
        this.sysUserService.updateById((Object)user);
        return baseResponse;
    }

    @ApiOperation(value="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801", notes="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801 reset password")
    @PutMapping(value={"/password/reset"})
    public BaseResponse<BizGeneralResponse> passwordResetEntity(@RequestBody SysUserChangePwdRequest pwdRequest) {
        BaseResponse baseResponse = new BaseResponse();
        SysUser user = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)pwdRequest.getUserId())));
        boolean result = false;
        if (ObjectHelper.isNotEmpty((Object)((Object)user))) {
            user.setLoginPwd(UserHelper.userPassword("123456"));
            result = this.sysUserService.updateById((Object)user);
        }
        baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        return baseResponse;
    }

    @ApiOperation(value="\u7528\u6237\u5bfc\u51fa", notes="\u7528\u6237\u5bfc\u51fa export user data")
    @GetMapping(value={"/export"})
    public void exportAllEntity(SysUserParam params, @RequestParam(value="cols", required=false) List<String> cols, @RequestParam(value="ids", required=false) List<String> ids, HttpServletResponse response) {
        SysUserParam param = (SysUserParam)ObjectHelper.defaultIfNull((Object)params, (Object)new SysUserParam());
        if (StringHelper.isNotBlank((CharSequence)param.getOrgId())) {
            param.setOrgId(((SysUser)((Object)this.sysUserService.getById((Serializable)((Object)this.getUserId())))).getOrgId());
        }
        QueryWrapper<SysUser> queryWrapper = this.createQuery(param);
        if (ObjectHelper.isNotEmpty(ids) && !ids.isEmpty()) {
            queryWrapper.in((Object)"user_id", ids);
        }
        List resultList = this.sysUserService.list((Wrapper)queryWrapper);
        List records = resultList.stream().map(bean -> (SysUserListResponse)bean.beanToBean(SysUserListResponse.class)).collect(Collectors.toList());
        List userExports = records.stream().map(e -> (UserExport)BeanHelper.beanToBean((Object)e, UserExport.class)).peek(UserExport::convertSex).collect(Collectors.toList());
        for (UserExport userExport : userExports) {
            userExport.setOrgName(this.sysOrgService.getOrgFullPathName(userExport.getOrgId()));
        }
        try {
            this.excelService.export("\u7528\u6237\u4fe1\u606f\u6570\u636e-" + DatetimeHelper.getDateTime8Length(), userExports, UserExport.class, response, cols);
        }
        catch (IOException e2) {
            log.error("Export Error ", (Throwable)e2);
            throw new ApiException(ExcelEnum.EXPORT_ERROR.transform());
        }
    }

    @ApiOperation(value="\u7528\u6237\u5bfc\u5165", notes="\u7528\u6237\u5bfc\u5165 Upload EXCEL File")
    @PostMapping(value={"/upload"})
    public BaseResponse<UserImportResponse> upload(@RequestParam MultipartFile file) {
        BaseResponse baseResponse = new BaseResponse();
        UserImportResponse userImportResponse = new UserImportResponse();
        if (file.isEmpty()) {
            throw new ApiException(ExcelEnum.NO_EXPORT_FILE.transform());
        }
        String filepath = this.excelService.importExcel(file);
        TongExcelListener<UserImport> tongExcelListener = new TongExcelListener<UserImport>(this.userExcelImportService, UserImport.class);
        EasyExcel.read((String)filepath, UserImport.class, tongExcelListener).sheet().doRead();
        List<ImportError<UserImport>> errorList = tongExcelListener.getErrorList();
        String fileName = this.saveErrorHistory(errorList);
        userImportResponse.setErrors(errorList.size() > 19 ? errorList.subList(0, 19) : errorList);
        userImportResponse.setErrorTotal(errorList.size());
        userImportResponse.setSuccessTotal(tongExcelListener.getSuccessList().size());
        userImportResponse.setBeans(ExcelDtoHelper.getCols(new UserImport()));
        userImportResponse.setFileName(fileName);
        baseResponse.setData((Object)userImportResponse);
        return baseResponse;
    }

    private String saveErrorHistory(List<ImportError<UserImport>> data) {
        String fileName = "";
        if (!data.isEmpty()) {
            ArrayList errors = new ArrayList(data.size());
            data.forEach(importError -> {
                UserImportError userImportError = (UserImportError)BeanHelper.beanToBean(importError.getData(), UserImportError.class);
                userImportError.setErrMsg(importError.getErrorMsg());
                errors.add(userImportError);
            });
            try {
                fileName = this.excelService.errorHistory(errors, UserImportError.class);
            }
            catch (FileNotFoundException e) {
                throw new ApiException(UserEnumCode.USER_IMPORT_ERROR_SAVE_FAIL.transform());
            }
        }
        return fileName;
    }

    private QueryWrapper<SysUser> createQuery(SysUserParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringHelper.isEmpty((CharSequence)queryParam.getLoginName())) {
            queryWrapper.like((Object)"login_name", (Object)queryParam.getLoginName());
        }
        if (!StringHelper.isEmpty((CharSequence)queryParam.getUserName())) {
            queryWrapper.like((Object)"user_name", (Object)queryParam.getUserName());
        }
        if (!StringHelper.isEmpty((CharSequence)queryParam.getPhoneNo())) {
            queryWrapper.like((Object)"phone_no", (Object)queryParam.getPhoneNo());
        }
        if (!StringHelper.isEmpty((CharSequence)queryParam.getUserType())) {
            queryWrapper.eq((Object)"user_type", (Object)queryParam.getUserType());
        }
        if (!StringHelper.isEmpty((CharSequence)queryParam.getOrgId())) {
            List orgList = this.sysOrgService.getChildrenById(queryParam.getOrgId()).stream().map(SysOrg::getOrgId).collect(Collectors.toList());
            if (orgList.isEmpty()) {
                queryWrapper.eq((Object)"org_id", (Object)queryParam.getOrgId());
            } else {
                orgList.add(queryParam.getOrgId());
                queryWrapper.in((Object)"org_id", orgList);
            }
        }
        if (StringHelper.isEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.in((Object)"status", Arrays.asList("0", "2"));
        } else if (!"1".equals(queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (!StringHelper.isEmpty((CharSequence)queryParam.getOrderBy())) {
            if (!StringHelper.isEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"user_name");
        }
        return queryWrapper;
    }
}

