/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.net.gmjsse;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.file.ConfigFileLoader;
import com.tongweb.web.util.net.SSLContext;
import com.tongweb.web.util.net.SSLHostConfig;
import com.tongweb.web.util.net.SSLHostConfigCertificate;
import com.tongweb.web.util.net.SSLUtilBase;
import com.tongweb.web.util.net.gmjsse.GMAdapterWST;
import com.tongweb.web.util.net.gmjsse.GMConstant;
import com.tongweb.web.util.net.gmjsse.GMSSLContext;
import com.tongweb.web.util.net.gmjsse.GMTrustManager;
import com.tongweb.web.util.res.StringManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;

public class GMUtil
extends SSLUtilBase {
    public static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(GMUtil.class);
    private static final StringManager sm = StringManager.getManager(GMUtil.class);
    private static final Set<String> implementedProtocols;
    private static final Set<String> implementedCiphers;
    private SSLHostConfigCertificate conf = null;
    private boolean isFirst = true;
    private boolean isUseWst = false;
    private static final String SERVICE_CLASS_NAME = "com.tongweb.chsm.performance.WSTFileEncDecService";

    public GMUtil(SSLHostConfigCertificate certificate) {
        this(certificate, true);
    }

    public GMUtil(SSLHostConfigCertificate certificate, boolean warnOnSkip) {
        super(certificate, warnOnSkip);
        this.conf = certificate;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public KeyManager[] getKeyManagers() {
        SSLHostConfig sslHostConfig = this.conf.getSSLHostConfig();
        String sigKeystoreFile = this.conf.getCertificateKeystoreFile();
        String sigKeystorePass = this.conf.getCertificateKeystorePassword();
        String encKeystoreFile = sslHostConfig.getTruststoreFile();
        String encKeystorePass = sslHostConfig.getTruststorePassword();
        String keystoreType = this.conf.getCertificateKeystoreType();
        KeyManager[] km = null;
        try (InputStream sigKeystoreFileStream = this.getInputStream(sigKeystoreFile);
             InputStream encKeystoreFileStream = this.getInputStream(encKeystoreFile);){
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(null, null);
            km = keyManagerFactory.getKeyManagers();
            Class<?> clzz = Class.forName("com.tongweb.gmssl.jsse.security.ssl.SunX509KeyManagerImpl");
            Object o = clzz.newInstance();
            Method init = clzz.getMethod("init", String.class, InputStream.class, String.class, InputStream.class, String.class);
            Object invoke = init.invoke(o, keystoreType, sigKeystoreFileStream, sigKeystorePass, encKeystoreFileStream, encKeystorePass);
            km = new KeyManager[]{(KeyManager)invoke};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return km;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        return new TrustManager[]{new GMTrustManager()};
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return implementedProtocols;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return implementedCiphers;
    }

    @Override
    public String[] getEnabledProtocols() {
        String[] protocols = super.getEnabledProtocols();
        String[] gmProtocls = new String[protocols.length + 2];
        for (int i = 0; i < protocols.length; ++i) {
            gmProtocls[i] = protocols[i];
        }
        gmProtocls[protocols.length] = GMConstant.GM_PROTOCOL;
        gmProtocls[protocols.length + 1] = "TLSv1.2";
        return gmProtocls;
    }

    @Override
    public String[] getEnabledCiphers() {
        int i;
        String[] ciphers = super.getEnabledCiphers();
        Vector<String> vector = new Vector<String>();
        for (i = 0; i < ciphers.length; ++i) {
            if (ciphers[i].indexOf("ECDSA") != -1 || ciphers[i].indexOf("_DSS_") != -1) continue;
            vector.addElement(ciphers[i]);
        }
        vector.addAll(GMConstant.CIPHERS);
        ciphers = new String[vector.size()];
        for (i = 0; i < vector.size(); ++i) {
            ciphers[i] = (String)vector.elementAt(i);
        }
        return ciphers;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return false;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> paramList) throws Exception {
        return new GMSSLContext(this.sslHostConfig.getSslProtocol());
    }

    private InputStream getInputStream(String location) throws IOException {
        if (this.isFirst) {
            this.isFirst = false;
            boolean isExist_Service = GMUtil.checkClassExists(SERVICE_CLASS_NAME);
            boolean isExist_Provider = GMUtil.checkClassExists("cn.com.westone.bouncycastle.jce.provider.WestoneProvider");
            boolean bl = this.isUseWst = isExist_Service && isExist_Provider;
        }
        if (this.isUseWst) {
            if (location.startsWith("jar:")) {
                throw new IOException("\u4f7f\u7528\u536b\u58eb\u901a\u56fd\u5bc6\u65f6\uff0c\u4e0d\u652f\u6301jar\u534f\u8bae\uff0c\u8bf7\u5c06[" + location + "]\u53e6\u5b58\u5230\u6587\u4ef6\u7cfb\u7edf");
            }
            return GMAdapterWST.getInputStream(location);
        }
        return ConfigFileLoader.getSource().getResource(location).getInputStream();
    }

    private static boolean checkClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public static void loadJar() throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String className = "cn.com.westone.util.SM2KeyUtil";
        URL resource = Class.forName(className).getProtectionDomain().getCodeSource().getLocation();
        if (resource != null) {
            System.out.println("The JAR file path is: " + resource.getFile());
        } else {
            System.out.println("Class not found or unable to determine the JAR file.");
        }
        URLClassLoader childClassLoader = new URLClassLoader(new URL[]{resource}, contextClassLoader);
        Thread.currentThread().setContextClassLoader(childClassLoader);
    }

    private static List<URL> getJarUrls(String directoryPath) throws IOException {
        File[] files;
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        File dir = new File(directoryPath);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String tempName = name.toLowerCase();
                if (tempName.endsWith(".jar")) {
                    if (tempName.startsWith("slf4j-api")) {
                        return true;
                    }
                    return tempName.startsWith("wst");
                }
                return false;
            }
        })) != null) {
            for (File file : files) {
                jarUrls.add(file.toURI().toURL());
            }
        }
        return jarUrls;
    }

    static {
        GMSSLContext context = null;
        try {
            context = new GMSSLContext(GMConstant.GM_PROTOCOL, GMConstant.GM_PROVIDER);
            context.init(null, null, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        String[] implementedProtocolsArray = context.getSupportedSSLParameters().getProtocols();
        implementedProtocols = new HashSet<String>(implementedProtocolsArray.length);
        for (String protocol : implementedProtocolsArray) {
            String protocolUpper = protocol.toUpperCase(Locale.ENGLISH);
            if (!"SSLV2HELLO".equals(protocolUpper) && !"SSLV3".equals(protocolUpper) && protocolUpper.contains("SSL")) {
                log.debug(sm.getString("jsse.excludeProtocol", protocol));
                continue;
            }
            implementedProtocols.add(protocol);
        }
        if (implementedProtocols.size() == 0) {
            log.warn(sm.getString("jsse.noDefaultProtocols"));
        }
        String[] implementedCipherSuiteArray = context.getSupportedSSLParameters().getCipherSuites();
        implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length);
        implementedCiphers.addAll(Arrays.asList(implementedCipherSuiteArray));
    }
}

